Type TMedia

	Global media:TMap = CreateMap()
	
	Field desc:String
	Field cat:String
	Field obj:Object
	Field option:Int
	Field path:String
	Field kb:Long
	Field err:Int
	
	Field Loader_Text:TSprite
	Field Loader_Spiral:TSprite
	
	Field Loader_Text_Texture:TTexture = CreateTexture(32, 32)
	Field Loader_Spiral_Texture:TTexture = CreateTexture(32, 32)
	
	Field Loader_Progress:Int
	Field Loader_Scale:Float = 0.1
	
	Global totalkb:Int

	
	' ------------------------------------------------------------------------------------------------
	' Init Media Loader
	' ------------------------------------------------------------------------------------------------
	Method Init(cam:TCamera)
		
		' Create a Sprite for the Loader Text
		Loader_Text = CreateSprite(cam)
		ScaleSprite Loader_Text, 2, 1
		PositionEntity Loader_Text, 0, 0.5, 5
		EntityBlend Loader_Text, 3
		EntityOrder Loader_Text, -2
		
		' Create a Sprite for the spinning Animation
		Loader_Spiral = CreateSprite(cam)
		ScaleSprite Loader_Spiral, 2, 2
		RotateEntity Loader_Spiral, 80, 0, 0
		SpriteViewMode Loader_Spiral, 2
		PositionEntity Loader_Spiral, 0, -0.5, 4
		EntityBlend Loader_Spiral, 3
		EntityColor Loader_Spiral, 0, 128, 255
		EntityOrder Loader_Spiral, -1
				
		' Hide both
		HideEntity Loader_Text
		HideEntity Loader_Spiral
					
	End Method

	
	' ------------------------------------------------------------------------------------------------
	' Update Media Loader
	' ------------------------------------------------------------------------------------------------
	Method Update()
		
		' Update Animation
		Loader_Progress:+1
		RoTex(Loader_Spiral_Texture, Loader_Progress)
		
		' Apply textures
		EntityTexture Loader_Text, Loader_Text_Texture
		EntityTexture Loader_Spiral, Loader_Spiral_Texture
		
		' Make visible
		ShowEntity Loader_Text
		ShowEntity Loader_Spiral
				
		' Render
		RenderWorld
		Flip False
		
		' Small pause
		'Delay 1

		' Hide again
		HideEntity Loader_Text
		HideEntity Loader_Spiral

	End Method

		
	' ------------------------------------------------------------------------------------------------
	' Create a Media Object
	' ------------------------------------------------------------------------------------------------
	Method Create:TMedia(cat:String, desc:String, w:Int = 0, h:Int = 0, option:Int = Null)
	
		Local m:TMedia = New Tmedia

		m.desc = desc
		m.cat = cat
		
		Select cat
			
			Case "P" m.obj = CreatePixmap(w, h, option)
			Case "T" m.obj = CreateTexture(w, h, option)
			Case "X" m.obj = CreateSprite()
			Case "M" m.obj = CreateMesh()

		End Select

		If m.obj Then
		
			m.kb = (w * h * 4)
			totalkb:+m.kb
			LogUpdate(FormatText(TIME.ElapsedTime()) + ": " + LOCALE.Get("LOG_MEDIACREATED") + ": " + m.desc)
			MapInsert(MEDIA, desc, m)

		EndIf
		
		Return m
						
	End Method


	' ------------------------------------------------------------------------------------------------
	' Assign a Mesh Entity to a Media Object
	' ------------------------------------------------------------------------------------------------
	Method AssignMesh:TMedia(e:TMesh, desc:String)
	
		Local m:TMedia = New Tmedia
		m.desc = desc
		m.cat = "M"
		m.obj = e
		
		LogUpdate(LOCALE.Get("LOG_MESHASSIGNED") + ": " + m.desc)
		
		MapInsert(MEDIA, desc, m)
		
		Return m

	End Method


	' ------------------------------------------------------------------------------------------------
	' Assign a Light Entity to a Media Object
	' ------------------------------------------------------------------------------------------------
	Method AssignLight:TMedia(e:TLight, desc:String)
	
		Local m:TMedia = New Tmedia
		m.desc = desc
		m.cat = "L"
		m.obj = e
		
		LogUpdate(LOCALE.Get("LOG_LIGHTASSIGNED") + ": " + m.desc)
		
		MapInsert(MEDIA, desc, m)
		
		Return m

	End Method


	' ------------------------------------------------------------------------------------------------
	' Load a Media Object
	' ------------------------------------------------------------------------------------------------
	Method Load:TMedia(cat:String, desc:String, file:String, option:Int = Null, showprogess:Int = True, framewidth:Int = 0, frameheight:Int = 0, firstframe:Int = 1, framecount:Int = 1)
	
		Local m:TMedia = New Tmedia

		m.desc = desc
		m.cat = cat
		m.option = option
		m.kb = 0
		m.err = False
		
		Local check:TStream = OpenStream(m.path)
		
		If Not check Then m.err = True Else CloseStream check 
		
		If Not err Then
								
			Select cat
			
				Case "F"
					m.path = PATH_Font + file
					m.obj = LoadImageFont(m.path, option, SMOOTHFONT)
					
				Case "P"
					m.path = PATH_Texture + file
					m.obj = LoadPixmap(m.path)

				Case "I"
					m.path = PATH_Texture + file
					m.obj = LoadImage(m.path)
					
				Case "S"
					m.path = PATH_Sound + file
					m.obj = LoadSound(m.path, option)
					
				Case "T"
					m.path = PATH_Texture + file
					m.obj = LoadTexture(m.path, option)
										
				Case "A"
					m.path = PATH_Texture + file
					m.obj = LoadAnimTexture(PATH_Texture + file, option, framewidth, frameheight, firstframe, framecount)
					
				Case "M"
					m.path = PATH_Models + file
					m.obj = LoadAnimMesh(m.path)
					
				Case "X"
					m.path = PATH_Texture + file
					m.obj = LoadSprite(m.path, option)

			End Select
						
			If m.obj Then
		
				m.kb = FileSize(m.path)
				totalkb:+m.kb
				LogUpdate(FormatText(TIME.ElapsedTime()) + ": " + m.path)
			
			Else
		
				Select m.cat
			
					Case "T" m.obj = GetTexture("NOTEX")
					Case "A" m.obj = GetTexture("NOTEX")
			
				End Select
				
				LogUpdate(LOCALE.Get("LOG_ERRORLOADING") + ": " + m.path)
		
			End If
		
			If showprogess Then Update()
						
			MapInsert(MEDIA, desc, m)
				
			Return m
		
		EndIf
						
	End Method
	

	' ------------------------------------------------------------------------------------------------
	' Unloads a MEDIA Object And frees the memory it used
	' ------------------------------------------------------------------------------------------------
	Method Unload(Key:String)
	
		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
		
		Select m.cat
								
			Case "T" If TTexture(m.obj) Then FreeTexture TTexture(m.obj) ; totalkb:-m.kb ; m.obj = Null ; m = Null
			Case "A" If TTexture(m.obj) Then FreeTexture TTexture(m.obj) ; totalkb:-m.kb ; m.obj = Null ; m = Null
			Case "M" If TMesh(m.obj) Then FreeEntity TMesh(m.obj) ; totalkb:-m.KB ; m.obj = Null ; m = Null
			Case "E" If TMesh(m.obj) Then FreeEntity TMesh(m.obj) ; totalkb:-m.KB ; m.obj = Null ; m = Null
			Case "F" If TImageFont(m.obj) Then totalkb:-m.KB ; m.obj = Null ; m = Null
			Case "S" If TSound(m.obj) Then totalkb:-m.KB ; m.obj = Null ; m = Null ; Print "#" + totalkb

		End Select
		
		
							
	End Method


					
	' ------------------------------------------------------------------------------------------------
	' Returns Texture Object
	' ------------------------------------------------------------------------------------------------
	Method GetTexture:TTexture(Key:String)
	
		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
				
		If m.cat = "T" Or m.cat = "A" Then Return TTexture(m.obj)
		
		Return Null
	
	End Method


	' ------------------------------------------------------------------------------------------------
	' Returns Pixmap Object
	' ------------------------------------------------------------------------------------------------
	Method GetPixmap:TPixmap(Key:String)

		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
		
		If m.cat = "P" Then Return TPixmap(m.obj)
		
		Return Null
	
	End Method



	' ------------------------------------------------------------------------------------------------
	' Returns Image Object
	' ------------------------------------------------------------------------------------------------
	Method GetImage:TImage(Key:String)

		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
		
		If m.cat = "I" Then Return TImage(m.obj)
		
		Return Null
	
	End Method
	

	' ------------------------------------------------------------------------------------------------
	' Returns Sound Object
	' ------------------------------------------------------------------------------------------------
	Method GetSound:TSound(Key:String)

		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
		
		If m.cat = "S" Then Return TSound(m.obj)
		
		Return Null
	
	End Method


	' ------------------------------------------------------------------------------------------------
	' Returns Font Object
	' ------------------------------------------------------------------------------------------------
	Method GetFont:TImageFont(Key:String)

		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
				
		If m.cat = "F" Then Return TImageFont(m.obj)
		
		Return Null
	
	End Method
	

	' ------------------------------------------------------------------------------------------------
	' Returns Mesh Object
	' ------------------------------------------------------------------------------------------------
	Method GetMesh:TMesh(Key:String)

		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
		
		If m.cat = "m" Then Return TMesh(m.obj)
		
		Return Null
	
	End Method

	' ------------------------------------------------------------------------------------------------
	' Returns Sprite Object
	' ------------------------------------------------------------------------------------------------
	Method GetSprite:TSprite(Key:String)

		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
		
		If m.cat = "X" Then Return TSprite(m.obj)
		
		Return Null
	
	End Method


	' ------------------------------------------------------------------------------------------------
	' Returns Light Object
	' ------------------------------------------------------------------------------------------------
	Method GetLight:TLight(Key:String)

		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
		
		If m.cat = "L" Then Return TLight(m.obj)
		
		Return Null
	
	End Method

	' ------------------------------------------------------------------------------------------------
	' Returns Options of an Object
	' ------------------------------------------------------------------------------------------------
	Method GetOption:Int(Key:String)

		Local m:TMedia = TMedia(MapValueForKey(MEDIA, Key))
		
		If Key = m.desc Then Return m.option
		
		Return Null
	
	End Method
	
End Type