' ------------------------------------------------------------------------------------------------
' Time measurement for subtasks
' ------------------------------------------------------------------------------------------------
Type TFlag

	Field Key:String
	Field Value:Int

	Global list:TList = CreateList()


	' --------------------------------------------------------------------------------------------
	' METHOD: Create new Object in TList
	' --------------------------------------------------------------------------------------------
	Method New()

		ListAddLast(list, Self)

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Add Flag
	' --------------------------------------------------------------------------------------------
	Method Add(Key:String, Value:Int)

		Local t:TFlag = New TFlag

		t.Key = Upper(Key)
		t.Value = Value

	End Method

	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Check Flag
	' --------------------------------------------------------------------------------------------
	Method Check(Key:String, ent:TEntity)
	
		If Get(Key) Then ShowEntity ent Else HideEntity ent

	End Method


	' --------------------------------------------------------------------------------------------
	' METHOD: Set Flag
	' --------------------------------------------------------------------------------------------
	Method Set:Int(Key:String, Value:Int)

		For Local t:TFlag = EachIn TFlag.list

			If Upper(Key) = t.Key Then Return t.Value = Value

		Next

	End Method
	


	' --------------------------------------------------------------------------------------------
	' METHOD: Switch Flag
	' --------------------------------------------------------------------------------------------
	Method Switch(Key:String)

		For Local t:TFlag = EachIn TFlag.list

			If Upper(Key) = t.Key Then
			
				t.Value = 1 - t.Value
				LogUpdate("Flag " + Key + " switched to " + t.Value)
				
			EndIf
			
		Next

	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Get Flag
	' --------------------------------------------------------------------------------------------
	Function Get:Int(Key:String)

		For Local t:TFlag = EachIn TFlag.list

			If Upper(Key) = t.Key Then Return t.Value

		Next

		Return Null

	End Function



End Type