Type TAsteroid

	Field x:Float = 0.0, y:Float = 0.0, z:Float = 0.0
	Field dx:Float = 0.0, dy:Float = 0.0, dz:Float = 0.0
	Field rotation:Float = 0.0
	Field rotationspeed:Float = 0.0
	Field R:Int = 255, G:Int = 255, B:Int = 255, A:Float = 1.0
	Field Scale:Float = 0.1
	Field v:Int = 0
	Field id:Int = 0
	Field mesh:TMesh = Null
	Field surf:TSurface = Null
	Field d:Float
	Field updated:Int
	Field updatedist:Int
	Field updatenorm:Int
	Field Hidden:Int
	
	Field ROWS:Int = 1
	Field Camera:TCamera

	Field VX0:Float, VX1:Float, VX2:Float, VX3:Float
	Field VY0:Float, VY1:Float, VY2:Float, VY3:Float
	Field VZ0:Float, VZ1:Float, VZ2:Float, VZ3:Float

	Global list:TList = CreateList()

	Method New()

		ListAddLast(list, Self)

	End Method

	Method Add()

		Local uvx:Float, uvy:Float
		Local uv1:Float, uv2:Float
		Local vv1:Float, vv2:Float
		Local V0:Int, V1:Int, V2:Int, V3:Int

		' surface setup
		If surf = Null Then surf = surf
		If v + 4 > 32768 Then
			v = 0
			surf = CreateSurface(mesh)
		EndIf

		' calc UV position
		uvy = Int(id) / ROWS
		uvx = Int(id) - (uvy * ROWS)
		uv1 = uvx * (1.0 / ROWS)     '0.0
		uv2 = (uvx + 1) * (1.0 / ROWS) '1.0
		vv1 = uvy * (1.0 / ROWS)     '0.0
		vv2 = (uvy + 1) * (1.0 / ROWS) '1.0

		' add Vertices
		V0 = AddVertex(surf, 0, 0, 0, uv2, vv1)
		V1 = AddVertex(surf, 0, 0, 0, uv2, vv2)
		V2 = AddVertex(surf, 0, 0, 0, uv1, vv2)
		V3 = AddVertex(surf, 0, 0, 0, uv1, vv1)
	
		' color vertices
		VertexColor surf, V0, R, G, B, A
		VertexColor surf, V1, R, G, B, A
		VertexColor surf, V2, R, G, B, A
		VertexColor surf, V3, R, G, B, A

		' connect triangles
		AddTriangle surf, V0, V1, V2
		AddTriangle surf, V0, V2, V3

		' increase vertex counter
		v = V0 + 4
		Update()

		d = Distance3D(x, y, z, EntityX(CAMERA), EntityY(CAMERA), EntityZ(CAMERA))

	End Method

	Method Hide()

		Local d:Int = 2 ^ 32

		' set vertices
		VertexCoords surf, v + 0, d, d, d
		VertexCoords surf, v + 1, d, d, d
		VertexCoords surf, v + 2, d, d, d
		VertexCoords surf, v + 3, d, d, d

	End Method

	Method Update(normals:Int = False)

		Local X1:Float, Y1:Float, Z1:Float
		Local X2:Float, Y2:Float, Z2:Float

		x = x + dx
		y = y + dy
		z = z + dz

		rotation = rotation + rotationspeed

		PositionEntity PIVOT, x, y, z
		PointEntity PIVOT, CAMERA
		RotateEntity PIVOT, EntityPitch(PIVOT), EntityYaw(PIVOT), rotation

		TFormVector 0, -Scale, 0, PIVOT, Null
		X1 = TFormedX()
		Y1 = TFormedY()
		Z1 = TFormedZ()
    
		TFormVector - Scale, 0, 0, PIVOT, Null
		X2 = TFormedX()
		Y2 = TFormedY()
		Z2 = TFormedZ()

		' calculate New vertex positions
		VX0 = x - X1 - X2
		VY0 = y - Y1 - Y2
		VZ0 = z - Z1 - Z2
		VX1 = x - X1 + X2
		VY1 = y - Y1 + Y2
		VZ1 = z - Z1 + Z2
		VX2 = x + X1 + X2
		VY2 = y + Y1 + Y2
		VZ2 = z + Z1 + Z2
		VX3 = x + X1 - X2
		VY3 = y + Y1 - Y2
		VZ3 = z + Z1 - Z2

		' set vertices
		VertexCoords surf, v + 0, VX0, VY0, VZ0
		VertexCoords surf, v + 1, VX1, VY1, VZ1
		VertexCoords surf, v + 2, VX2, VY2, VZ2
		VertexCoords surf, v + 3, VX3, VY3, VZ3

		' set colors
		VertexColor surf, v + 0, R, G, B, A
		VertexColor surf, v + 1, R, G, B, A
		VertexColor surf, v + 2, R, G, B, A
		VertexColor surf, v + 3, R, G, B, A

		' calculate new vertex normals
		If normals Then RecalcNormals()

	End Method

	Method RecalcNormals()

		Local PX:Float, PY:Float, PZ:Float
		Local QX:Float, QY:Float, QZ:Float
		Local NX:Float, NY:Float, NZ:Float

		PX = VX1 - VX0
		PY = VY1 - VY0
		PZ = VZ1 - VZ0
		QX = VX2 - VX0
		QY = VY2 - VY0
		QZ = VZ2 - VZ0

		NX = ((PY * QZ) - (PZ * QY))
		NY = ((PZ * QX) - (PX * QZ))
		NZ = ((PX * QY) - (PY * QX))
			 
		' set normals
		VertexNormal surf, v + 0, NX, NY, NZ
		VertexNormal surf, v + 1, NX, NY, NZ
		VertexNormal surf, v + 2, NX, NY, NZ
		VertexNormal surf, v + 3, NX, NY, NZ

	End Method

End Type