' ------------------------------------------------------------------------------------------------
' Change resolution (ingame)
' ------------------------------------------------------------------------------------------------
Function SetResolution(width:Int, Height:Int, depth:Int = 32, mode:Int = 1)

	TIME.Start
	
	CAMERA.Update
	
	Local x:Float = CAMERA.OX
	Local y:Float = CAMERA.OY
	Local z:Float = CAMERA.OZ
	Local pitch:Float = CAMERA.OPitch
	Local yaw:Float = CAMERA.OYaw
	Local roll:Float = CAMERA.ORoll

	SetGadgetShape MAXGUI_WINDOW, SCREEN_CENTERX - (width / 2), SCREEN_CENTERY - (Height / 2), width, Height
	
	TGlobal.width = width
	TGlobal.Height = Height
	TGlobal.depth = depth
	TGlobal.mode = mode
		
	SCREEN_WIDTH = width
	SCREEN_HEIGHT = Height
	SCREEN_DEPTH = depth
	SCREEN_MODE = mode
			
	' reset camera
	CAMERA.width = SCREEN_WIDTH
	CAMERA.Height = SCREEN_HEIGHT
	CAMERA.MX = SCREEN_WIDTH / 2
	CAMERA.MY = SCREEN_HEIGHT / 2
	CAMERA.x = x
	CAMERA.y = y
	CAMERA.z = z
	CAMERA.pitch = pitch
	CAMERA.yaw = yaw
	CAMERA.roll = roll
	CAMERA.Update()
		
	' repositon camera
	PositionEntity CAMERA.CAM, x, y, z
	RotateEntity CAMERA.CAM, pitch, yaw, roll
	
	' recalculate Scale
	UpdateScaler()
			
	TIME.Stop(LOCALE.Get("LOG_SETRESOLUTION") + " " + width + "x" + Height)
		
End Function



' --------------------------------------------------------------------------------
' Update Screen Scale
' --------------------------------------------------------------------------------
Function UpdateScaler()

	Scaler = SCREEN_WIDTH / 2560.0
	SCREEN_ASPECT = SCREEN_WIDTH * 1.0 / SCREEN_HEIGHT

End Function


' --------------------------------------------------------------------------------
' Fixed BeginMax2D()
' --------------------------------------------------------------------------------
Function BeginMax2D()

	Local x:Int, y:Int, w:Int, h:Int
	GetViewport(x, y, w, h)
		
	glDisable(GL_LIGHTING)
	glDisable(GL_DEPTH_TEST)
	glDisable(GL_SCISSOR_TEST)
	glDisable(GL_FOG)
	glDisable(GL_CULL_FACE)

	glMatrixMode GL_TEXTURE
	glLoadIdentity
		
	glMatrixMode GL_PROJECTION
	glLoadIdentity
	glOrtho 0, GraphicsWidth(), GraphicsHeight(), 0, -1, 1
		
	glMatrixMode GL_MODELVIEW
	glLoadIdentity
		
	SetViewport x, y, w, h
				
	Local MaxTex:Int
	glGetIntegerv(GL_MAX_TEXTURE_UNITS, VarPtr(MaxTex))

		
	For Local Layer:Int = 0 Until MaxTex
		glActiveTexture(GL_TEXTURE0 + Layer)
					
		glDisable(GL_TEXTURE_CUBE_MAP)
		glDisable(GL_TEXTURE_GEN_S)
		glDisable(GL_TEXTURE_GEN_T)
		glDisable(GL_TEXTURE_GEN_R)
	
		glDisable(GL_TEXTURE_2D)
	Next
		
	glActiveTexture(GL_TEXTURE0)
				
	glViewport(0, 0, TGlobal.width, TGlobal.Height)
	glScissor(0, 0, TGlobal.width, TGlobal.Height)

	glEnable GL_BLEND
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
	glEnable(GL_TEXTURE_2D)
	
End Function



' --------------------------------------------------------------------------------
' Fixed EndMax2D()
' --------------------------------------------------------------------------------
Function EndMax2D()

	glDisable(GL_TEXTURE_CUBE_MAP)
	glDisable(GL_TEXTURE_GEN_S)
	glDisable(GL_TEXTURE_GEN_T)
	glDisable(GL_TEXTURE_GEN_R)
	
	glDisable(GL_TEXTURE_2D)
		
	TGlobal.EnableStates()

End Function
