' DrawShadowText(txt:String, x:Int, y:Int, r1:Int = 255, g1:Int = 255, b1:Int = 255, r2:Int = 0, g2:Int = 0, b2:Int = 0)
' DrawTextWrap(t:String, x:Float, y:Float, w:Float = 0, h:Float = 0, align:Int = 0)



' ----------------------------------------------------------------------------
' Draws text with simple shadow
' ----------------------------------------------------------------------------
Function DrawShadowText(txt:String, x:Int, y:Int, r1:Int = 255, g1:Int = 255, b1:Int = 255, r2:Int = 0, g2:Int = 0, b2:Int = 0)

	SetColor r2, g2, b2
	DrawText txt, x + 1, y + 1

	SetColor r1, g1, b1
	DrawText txt, x, y

End Function



' ------------------------------------------------------------------------------------------------
' Drawtext with wordwrap function
' ------------------------------------------------------------------------------------------------
Const H_ALIGN_LEFT:Int = 0
Const H_ALIGN_CENTER:Int = 1
Const H_ALIGN_RIGHT:Int = 2
Const V_ALIGN_TOP:Int = 0
Const V_ALIGN_MIDDLE:Int = 4
Const V_ALIGN_BOTTOM:Int = 8

Function DrawTextWrap(t:String, x:Float, y:Float, w:Float = 0, h:Float = 0, align:Int = 0)

	Local textlines:String[1]
	Local linecount:Int = 1
	textlines[0] = t:String

	Local fitwidth:Int = True
	
	If w <= 0 Then
	
		' No fixed limit, if w isn't set
		w = 100000
		fitwidth = False
		
	End If
				
	linecount = 1
	textlines[0] = ""
	Local index:Int = 0
	Local oldindex:Int = 0
	Local newline:Int = False
	
	While oldindex < t.length - 1
		
		newline = False
			
		index = t.length - 1
			
		For Local i:Int = oldindex To t.length - 1
		
			If t[i] = 10 Then
			
				index = i
				newline = True
				Exit
				
			ElseIf t[i] <= 32 Then
			
				index = i
				Exit
				
			EndIf
			
		Next
		
		If newline
		
			If TextWidth(textlines[linecount - 1] + t[oldindex..index + 1]) < w Then
			
				textlines[linecount - 1]:+t[oldindex..index + 1]
				linecount:+1
				textlines = textlines[..linecount]
				textlines[linecount - 1] = ""
				
			Else
			
				linecount:+1
				textlines = textlines[..linecount]
				textlines[linecount - 1] = " " + t[oldindex..index + 1]
				
			EndIf
			
		ElseIf TextWidth(textlines[linecount - 1] + t[oldindex..index + 1]) < w Or textlines[linecount - 1].length = 0 Then
		
			textlines[linecount - 1]:+t[oldindex..index + 1]
			
		Else
		
			linecount:+1
			textlines = textlines[..linecount]
			textlines[linecount - 1] = ""
			index = oldindex - 1
			
		EndIf
		
		oldindex = index + 1
		
	Wend

	If fitwidth = False Then
	
		' Reset w to 0
		w = 0
		
	EndIf
				
	If align & V_ALIGN_MIDDLE Then
	
		y = y + h * 0.5 - TextHeight(t:String) * linecount *.5
		
	ElseIf align & V_ALIGN_BOTTOM Then
	
		y = y + h - TextHeight(t:String) * linecount
		
	EndIf

	Local dx:Float

	For t:String = EachIn textlines
	
		dx = x
		
		If align & H_ALIGN_CENTER Then
		
			dx = x + w * 0.5 - TextWidth(t:String) *.5
			
		ElseIf align & H_ALIGN_RIGHT
		
			dx = x + w - TextWidth(t:String)
			
		EndIf

		DrawText t, dx, y

		y:+TextHeight(t:String)
		
	Next
	
End Function