' Cut:String(value:Float,digits:Int=2)
' FormatINT:String(Value:String, div:String = ".")
' FormatText:String(Value:String, Size:Int = 3)
' Spaces:String(Value:String, Length:Int = 5)
' FillSpaces:String(Value:String, Length:Int = 20, character:String = ".")
' DigOut:String(in:String, delimiter:String = ".")
' FormOut:String(in:String, spaces:Int = 2, prefix:String = " ")
' FormStr:String(in:String, spaces:Int = 2, suffix:String = " ")
' FileTimeWithFormat:String(path:String, format:String = "%B %d %Y")


' returns a 14 digit string of year+month+day+hour+min+sec
Function time_now:String()

  Local cd:String, ct:String, month1:String, month2:String
  		
  month1 = "ANEBARPRAYUNULUGEPCTOVEC"  ' last 2 letters of each month name
  month2 = "010203040506070809101112"  ' 2 digit equivalent
  
  cd:String = CurrentDate()
  ct:String = CurrentTime()
  
  ' the month is converted from CurrentDate$ to a 2 digit string

  Return Mid(cd:String, 8, 4) + "-" + Mid(month2, Instr(month1, Upper(Mid(cd, 5, 2))), 2) + "-" + Mid(cd, 1, 2) + " " + Mid(ct, 1, 2) + "." + Mid(ct, 4, 2) + "." + Mid(ct, 7, 2)

End Function


' ----------------------------------------------------------------------------
' Rounds a Float value to a given number of digits
' ----------------------------------------------------------------------------
Function Cut:String(value:Float,digits:Int=2)
	
	Local i:Int
	Local factor:Float=10^digits
	Local ints:Int=Int(Floor(value))
	Local modstring:String=(Int((value-ints)*factor))
	Local modlength:Int=Len(modstring)
	
	If modlength<digits Then
	
		For i=1 To (digits-modlength)
			
			modstring=modstring+"0"
			
		Next
		
	EndIf
	
	Return ints+"."+modstring
	
End Function



' ------------------------------------------------------------------------------------------------
' FUNCTION: Output an int with dividing dots
' ------------------------------------------------------------------------------------------------
Function FormatINT:String(Value:String, div:String = ".")

	Local i:Int
	Local out:String
	Local Length:Int = Len(Value)

	For i = Length - 1 To 0 Step - 1

		out = Mid(Value, 1 + i, 1) + out
		If i And Not ((Length - i) Mod 3) Then out = div + out
		
	Next

	Return out

End Function



' --------------------------------------------------------------------------------------------
' FUNCTION: Formatted Text Output
' --------------------------------------------------------------------------------------------
Function FormatText:String(Value:String, Size:Int = 3)

	Local out:String
	Local Length:Int = Len(Value)
	
	If Length < Size Then

		For Local i:Int = 0 To Size - 1 - Length

			out:+" "
			
		Next

	EndIf

	Return out + Value + "ms"

End Function



' --------------------------------------------------------------------------------------------
' Adds leading spaces to a string (for ex. a number) to make all values equal in width
' --------------------------------------------------------------------------------------------
Function Spaces:String(Value:String, Length:Int = 5, char:String = " ")

	Local l:Int = Len(Value)
	Local s:String
	
	If Length > (l - 1) Then
	
		For Local i:Int = 0 To Length - l - 1
	
			s:+char

		Next
		
	EndIf
	
	Return s + Value
	
End Function



' --------------------------------------------------------------------------------------------
' Adds additional characters to a string to make all lines equal in width
' --------------------------------------------------------------------------------------------
Function FillSpaces:String(Value:String, Length:Int = 24, character:String = ".")

	Local l:Int = Len(Value)
	Local s:String
	
	If Length > (l - 1) Then
	
		For Local i:Int = 0 To Length - l - 1
	
			s:+character

		Next
		
	EndIf
	
	Return Value + s
	
End Function


' --------------------------------------------------------------------------------
' Simple digit formatting output of a number
' --------------------------------------------------------------------------------
Function DigOut:String(in:String, delimiter:String = ".")

	Local l:Int = Len(in)
	Local j:Int
	Local negative:Int
	Local out:String
	
	If Int(in) < 0 Then negative = 1
	
	For j = l To 0 Step - 1

		out:+Mid(in, l - j, 1)

		If (j Mod 3) = 0 And j > 0 And (j < l - negative) Then out:+"."

	Next
	
	Return out

End Function



' --------------------------------------------------------------------------------
' Simple leading spaces for nice number formatting output
' --------------------------------------------------------------------------------
Function FormOut:String(in:String, spaces:Int = 2, prefix:String = " ")

	Local i:Int
	Local l:Int = Len(in)
	Local out:String
		
	If l < spaces Then
	
		For i = 0 To spaces - l - 1
		
			out:+prefix
		
		Next
	
	End If
	
	Return out + in
	
End Function




' --------------------------------------------------------------------------------
' Simple spacing for nice string formatting output
' --------------------------------------------------------------------------------
Function FormStr:String(in:String, spaces:Int = 2, suffix:String = " ")

	Local i:Int
	Local l:Int = Len(in)
	Local out:String
		
	If l < spaces Then
	
		For i = 0 To spaces - l - 1
		
			out:+suffix
		
		Next
	
	End If
	
	Return in + out
	
End Function



' ------------------------------------------------------------------------------------------------
' Return formatted filetime
' ------------------------------------------------------------------------------------------------
Function FileTimeWithFormat:String(path:String, format:String = "%B %d %Y")

	Local time:Int Ptr, buff:Byte[256], ftime:Int
	
	ftime = FileTime(path)
	time = Varptr(ftime)
	strftime_(buff, 256, format, localtime_(time))
	
	Return String.FromCString(buff)
	
End Function



' ------------------------------------------------------------------------------------------------
' Return a nicely formatted number
' ------------------------------------------------------------------------------------------------
Function FormatMath:String(Value:Double, floats:Int = 2, delimiter:Int = True)

	Local s:String=value
	Local e:Int=s.Find("e")
	Local exponent:Int

	Local i:Int=s.Find(".")

	Local integer:String
	Local floating:String

	' find out 10^exponent, positive and negative
	If e>0 Then exponent=Int(Mid(s,e+2,999)) Else exponent=Null

	' find out integer
	If i>0 Then

		integer=Mid(s,0,i+1)
		floating=Mid(s,i+2,floats)
		
		'If floats=0 Or Int(floating)=0 Then floating=Null
		If floats=0 Then floating=Null

	Else

		integer=s
		floating=Null
		
	EndIf

	' add dot dividers for integer
	If delimiter Then

		Local l:Int=Len(integer)
		Local out:String
		Local negative:Int

		If integer<0 Then negative=1

		For Local j:Int=l To 0 Step -1

			out:+Mid(integer, l - j, 1)

			If (j Mod 3) = 0 And j > 0 And (j < l - negative) Then out:+"."

		Next

		integer=out

	EndIf
	
	' output with exponent
	If floating And exponent And floating Then Return integer+","+floating+"x10^"+exponent
	If integer And exponent And (Not floating) Then Return integer+"x10^"+exponent
	
	' output without exponent
	If floating And (Not exponent) Then Return integer + "," + floating
	If (Not floating) And (Not exponent) Then Return integer

EndFunction