' Val:Int(txt:String)
' UTF:String(unicode:String)
' Unicode:String(UTF_8:String)
' BinInt:Int(this:String)
' Bin2Int:Int(binary:String)



' --------------------------------------------------------------------------------------------
' Value inside text string
' --------------------------------------------------------------------------------------------
Function Val:Int(txt:String)

	Local t:String = Upper(txt)
	Local p:Int = 1
	Local Value:Int
	Local i:Int

	For i = Len(txt) To 1 Step - 1

		Local v:Int = Asc(Mid(t, i, 1)) - 48

		If v > - 1 And v < 10 Then

			Value:+(v * p)
			p:*10

		End If

	Next

	Return Value

End Function



' ----------------------------------------------------------------------------
' Converts Unicode to UTF-8
' ----------------------------------------------------------------------------
Function UTF:String(unicode:String)

	Local i:Int
	Local char:String
	Local bytes:String
	Local byte1:String
	Local byte2:String
	Local byte3:String
	Local result:String = ""
		
	For i = 1 To Len(unicode)
		
		char = Mid:String(Unicode, i, 1)
		
		If Asc(char) < 128 Then
		
			RESULT:+char
			
		ElseIf Asc(char) > 127 And Asc(char) < 2048 Then
		
			bytes = Right(Bin(Asc(char)), 11)

			byte1 = "110" + Left(bytes, 5)
			result:+Chr(Bin2Int(byte1))

			byte2 = "10" + Right(bytes, 6)
			result:+Chr(Bin2Int(byte2))
			
		Else
		
			bytes = Right(Bin(Asc(char)), 16)

			byte1 = "1110" + Left(bytes, 4)
			result:+Chr(Bin2Int(byte1))

			byte2 = "10" + Mid(bytes, 5, 6)
			result:+Chr(Bin2Int(byte2))

			Byte3 = "10" + Right(bytes, 6)
			result:+Chr(Bin2Int(Byte3))
					
		EndIf
		
	Next
	
	Return RESULT
	
EndFunction



' ----------------------------------------------------------------------------
' Converts UTF8 to Unicode
' ----------------------------------------------------------------------------
Function Unicode:String(UTF_8:String)

	Local i:Int
	Local RESULT:String = ""
	Local UTF:String = ""
	Local char:String
	Local b:String
	Local length:Int = 0
	Local last:String = ""
	
	For i = 1 To Len(UTF_8)
	
		char = Mid(UTF_8, i, 1)
		
		B = Right(Bin(Asc(Char)), 8)
		
		If length > 0 Then
		
			UTF:+Right(B, 6)
			
			length:-1
			
			If Left(B, 2) <> "10" Then
			
				Length=0
				RESULT:+last
				last = ""
				
			ElseIf length = 0 Then
			
				RESULT:+Chr(Bin2Int(UTF))
				
			EndIf
			
		EndIf
			
		If length = 0 Then
		
			If Left(B, 1) = "0" Then
			
				Result:+Char
				length = 0
								
			ElseIf Left(B, 3) = "110" Then
			
				last = CHAR
				UTF = Right(B, 5)
				length = 1
				
			ElseIf Left(B, 4) = "1110" Then
			
				UTF = Right(B, 5)
				length = 2
				
			ElseIf Left:String(B, 4) = "11110"
			
				UTF = Right(B, 5)
				length = 3
				
			EndIf
			
		EndIf
		
	Next
	
	Return RESULT
	
End Function



' ------------------------------------------------------------------------------------------------
' Convert a binary (flag) String into an Int for binary comparison
' ------------------------------------------------------------------------------------------------
Function BinInt:Int(this:String)

	Local bint:Int = 0
	Local blen:Int = Len(this)
	
	For Local i:Int = 1 To blen
	
		Local bit:Int = Int(Mid(this, i, 1))
		If bit Then bint:+(bit * (2 ^ (blen - i)))
		
	Next
	
	Return bint
	
End Function



' ----------------------------------------------------------------------------
' Converts a Binary String to an Integer
' ----------------------------------------------------------------------------
Function Bin2Int:Int(binary:String)

	Return Int("%" + binary)
	
EndFunction