' SavePixmapTGA(pixmap:TPixmap, filename:String, depth:Int = 32)
' LoadTGA8bit:TPixmap(stream:TRamStream)



' ------------------------------------------------------------------------------------------------
' Load a 8bit TGA pixmap
' ------------------------------------------------------------------------------------------------
Function LoadTGA8bit:TPixmap(stream:TRamStream)

	Local w:Int, h:Int
	Local temp:TPixmap = Null
		
	If stream Then

		' read TGA header
		stream.Seek(8)
		stream.ReadShort() ' X
		stream.ReadShort() ' Y
		w = stream.ReadShort()
		h = stream.ReadShort()
		stream.ReadByte() ' pixel size
		stream.ReadByte() ' bitdepth
		
		' has width and height?
		If w > 0 And h > 0 Then
		
			' seek forward
			stream.Seek(16)
			
			' create new pixmap
			temp = CreatePixmap(w, h, PF_RGBA8888)
		
			' read pixels and convert to pixmap format
			Local buffer:Int[] = New Int[w]
			For Local yy:Int = h - 1 To 0 Step - 1
		
				stream.ReadBytes(buffer, w)
				ConvertPixels(buffer, PF_I8, temp.PixelPtr(0, yy), temp.format, w)
				
			Next
			
		EndIf
	
		Return temp
		
	Else
	
		Return Null
		
	EndIf
	
End Function



' ----------------------------------------------------------------------------
' Saves a Pixmap to a TGA File (32bit depth only!)
' ----------------------------------------------------------------------------
Function SavePixmapTGA(pixmap:TPixmap, filename:String, depth:Int = 32)

	Local width:Int = pixmap.width
	Local Height:Int = pixmap.Height
	
	Local x:Int, y:Int
	
	If Lower(Right(filename, 4)) <> ".tga" Then filename:+".tga"
	
	Local f:TStream = WriteFile(filename)
	
	WriteByte(f, 0) 'idlength
	WriteByte(f, 0) 'colormaptype
	WriteByte(f, 2) 'imagetype 2=rgb
	WriteShort(f, 0) 'colormapindex
	WriteShort(f, 0) 'colormapnumentries
	WriteByte(f, 0) 'colormapsize 
	WriteShort(f, 0) 'xorigin
	WriteShort(f, 0) 'yorigin
	WriteShort(f, width) 'width
	WriteShort(f, Height) 'height
	WriteByte(f, 32) 'pixsize
	WriteByte(f, 8) 'attributes
	
	For y = Height - 1 To 0 Step - 1
	
		For x = 0 To width - 1
		
			WriteInt(f, ReadPixel(pixmap, x, y))
			
		Next
	Next
	
	CloseFile f
		
End Function