' UpdateValue:Float(cur:Float, des:Float, rate:Float)
' Round:String(value:Double, floats:Int = 2, delimiter:Int = True)
' Normalize:Float(value:Float, vmin:Float, vmax:Float, nmin:Float, nmax:Float, limit:Int = False)
' RoundInt:Int(x:Float)
' MinMax:Int(nums:Int[], order:Int = 0)
' FloatMin:Float(a:Float,b:Float)
' FloatMax:Float(a:Float,b:Float)
' LimitInt:Int(value:Int,mn:Int,mx:Int)
' LimitFloat:Float(value:Float, mn:Float, mx:Float)
' Wrap:Float(value:Float, minimum:Float, range:Float)
' InRange:Int(value:Float, minimum:Float, maximum:Float)
' TitiusBode:Float(planet:Int)
' Fract:Float(num:Float)
' Between:Float(x:Float, a:Float, b:Float)
' Blend:Float(a:Float, b:Float, F:Float)

Include "FMath.Crypt.bmx"
Include "FMath.Interpolation.bmx"
Include "FMath.Trigonometry.bmx"



' ------------------------------------------------------------------------------------------------
' Updates a value with a rate
' ------------------------------------------------------------------------------------------------
Function UpdateValue:Float(cur:Float, des:Float, rate:Float)

	cur:+((des - cur) * rate)

	Return cur

End Function



' ------------------------------------------------------------------------------------------------
' Rounds a value
' ------------------------------------------------------------------------------------------------
Function Round:String(Value:Double, floats:Int = 2, delimiter:Int = True)

	Local s:String = Value
	Local e:Int = s.Find("e")
	Local exponent:Int

	Local i:Int = s.Find(".")

	Local integer:String
	Local floating:String

	' find out 10^exponent, positive and negative
	If e > 0 Then exponent = Int(Mid(s, e + 2, 999)) Else exponent = Null

	' find out integer
	If i > 0 Then

		integer = Mid(s, 0, i + 1)
		floating = Mid(s, i + 2, floats)
		
		'If floats=0 Or Int(floating)=0 Then floating=Null
		If floats = 0 Then floating = Null

		Else

			integer = s
		floating = Null
		
	EndIf

	' add dot dividers for integer
	If delimiter Then

		Local l:Int = Len(integer)
		Local out:String
		Local negative:Int

		If integer < 0 Then negative = 1

		For Local j:Int = l To 0 Step - 1

			out:+Mid(integer, l - j, 1)

			If (j Mod 3) = 0 And j > 0 And (j < l - negative) Then out:+"."

		Next

		integer = out

	EndIf
	
	' output with exponent
	If floating And exponent And floating Then Return integer + "," + floating + "x10^" + exponent
	If integer And exponent And (Not floating) Then Return integer + "x10^" + exponent

	' output without exponent
	If floating And (Not exponent) Then Return integer + "," + floating
	If (Not floating) And (Not exponent) Then Return integer

EndFunction



' ------------------------------------------------------------------------------------------------
' Normalizes a value to given range
' ------------------------------------------------------------------------------------------------
Function Normalize:Float(Value:Float, vmin:Float, vmax:Float, nmin:Float, nmax:Float, limit:Int = False)

	' normalize	
	Local result:Float = ((Value - vmin) / (vmax - vmin)) * (nmax - nmin) + nmin

	' limit
	If limit Then
	
		If Value >= nmax Then result = nmax
		If Value <= nmin Then result = nmin

	EndIf

	Return result
	
End Function



' ------------------------------------------------------------------------------------------------
' INT round in both directions
' ------------------------------------------------------------------------------------------------
Function RoundInt:Int(x:Float)
	
	If x >= 0 Then Return Floor(x) Else Return Ceil(x)
	
End Function



' --------------------------------------------------------------------------------
' Returns the maximum value of an array
' --------------------------------------------------------------------------------
Function MinMax:Int(nums:Int[], order:Int = 0)

	Local tmp:Int[] = nums[..]
	tmp.Sort()
	
	If order = 0 Then Return tmp[0] Else Return tmp[tmp.length - 1]
	
End Function



' ----------------------------------------------------------------------------
' Return Float Minimum of two values
' ----------------------------------------------------------------------------
Function FloatMin:Float(a:Float, b:Float)
	
	If a < b Then Return a Else Return b
	
End Function



' ----------------------------------------------------------------------------
' Return Float Maximum of two values
' ----------------------------------------------------------------------------
Function FloatMax:Float(a:Float, b:Float)
	
	If a > b Then Return a Else Return b
	
End Function



' ----------------------------------------------------------------------------
' Limit a integer value To a given range
' ----------------------------------------------------------------------------
Function LimitInt:Int(Value:Int, mn:Int, mx:Int)
	
	If Value > mx Then Value = mx
	If Value < mn Then Value = mn
	
	Return Value
	
End Function



' ------------------------------------------------------------------------------------------------
' Limit a float value To a given range
' ------------------------------------------------------------------------------------------------
Function LimitFloat:Float(Value:Float, mn:Float, mx:Float)
	
	If Value > mx Then Value = mx
	If Value < mn Then Value = mn
	
	Return Value
	
End Function


' ------------------------------------------------------------------------------------------------
' Wraps a value at a minimum value in a given range
' ------------------------------------------------------------------------------------------------
Function Wrap:Float(Value:Float, minimum:Float, Range:Float)

	If Value < minimum Then Return Value + Range Else If Value > minimum + Range Then Return Value - Range Else Return Value

End Function



' ------------------------------------------------------------------------------------------------
' Checks if a value is within a range and returns true if so, otherwise false
' ------------------------------------------------------------------------------------------------
Function InRange:Int(Value:Float, minimum:Float, maximum:Float)

	If Value >= minimum And Value < maximum Then Return True
	
	Return False

End Function



' ------------------------------------------------------------------------------------------------
' Titius Bode Law
' ------------------------------------------------------------------------------------------------
Function TitiusBode:Float(planet:Int)

	Return 0.4 + (0.3 * (2 ^ (planet - 2)))

End Function


' ------------------------------------------------------------------------------------------------
' Returns the fraction of a Float
' ------------------------------------------------------------------------------------------------
Function Fract:Float(num:Float)

	Return num - Floor(num)
	
End Function



' ------------------------------------------------------------------------------------------------
' Returns True if a value is between two values
' ------------------------------------------------------------------------------------------------
Function Between:Float(x:Float, a:Float, b:Float)

	If x < a Then Return False Else If x > b Return True
	
End Function



' ------------------------------------------------------------------------------------------------
' Blends two values with a factor
' ------------------------------------------------------------------------------------------------
Function Blend:Float(a:Float, b:Float, F:Float)

	Return a * F + b * (1.0 - F)

End Function