' PaintLayer(surface:TSurface, texture:TTexture, layer:Int = 0, fx:Int = 1, blend:Int = 1, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
' UpdateSurface(surf:TSurface, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
' AddToSurface(mesh:TMesh, surf:TSurface, singlesurfaceentity:TMesh, r:Int, g:Int, b:Int, a:Float)



' ------------------------------------------------------------------------------------------------
' Paints a surface layer with a brush
' ------------------------------------------------------------------------------------------------
Function PaintLayer(surface:TSurface, texture:TTexture, layer:Int = 0, fx:Int = 1, blend:Int = 1, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)

	Local brush:TBrush = CreateBrush(r, g, b)
	
	BrushAlpha brush, a
	BrushBlend brush, Blend
	BrushTexture brush, texture, 0, layer

	PaintSurface surface, brush

End Function


' ----------------------------------------------------------------------------
' Update Surface Vertex RGBA color
' ----------------------------------------------------------------------------
Function UpdateSurface(surf:TSurface, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
	
	For Local v:Int = 0 To CountVertices(surf) - 1

		VertexColor surf, v, r, g, b, a
		
	Next
	
End Function



' ----------------------------------------------------------------------------
' Adds a mesh to another mesh
' ----------------------------------------------------------------------------
Function AddToSurface(mesh:TMesh, surf:TSurface, singlesurfaceentity:TMesh, r:Int, g:Int, b:Int, a:Float)
	
	Local v:Int[3]
		
	Local surface:TSurface = GetSurface(mesh, 1)
		
	For Local i1:Int = 0 To CountTriangles(surface) - 1
			
		For Local i2:Int = 0 To 2
					
			Local oldv:Int = TriangleVertex(surface, i1, i2)
			TFormPoint VertexX(surface, oldv), VertexY(surface, oldv), VertexZ(surface, oldv), mesh, singlesurfaceentity
			v[i2] = AddVertex(surf, TFormedX(), TFormedY(), TFormedZ(), VertexU(surface, oldv), VertexV(surface, oldv))
			
			VertexNormal surf, v[i2], VertexNX(surface, oldv), VertexNY(surface, oldv), VertexNZ(surface, oldv)
			
			VertexColor surf, v[i2], r, g, b, a
						
		Next
		
		AddTriangle(surf, v[0], v[1], v[2])
				
	Next
	
End Function