' CreateGlow:TMesh(parent:TEntity = Null, radius1:Float = 1.0, radius2:Float = 2.0, segments:Int = 360, fx:Int = 0, blend:Int = 0, r1:Int = 255, g1:Int = 255, b1:Int = 255, al1:Float = 1.0, r2:Int = 255, g2:Int = 255, b2:Int = 255, al2:Float = 1.0, Inverse:Int = False)
' UpdateGlow(mesh:TMesh, radius1:Float = 1.0, radius2:Float = 2.0, segments:Int = 360)
' UpdateInnerGlow(mesh:TMesh,alpha:Float=0.0)
' UpdateOuterGlow(mesh:TMesh,alpha:Float=0.0)
' UpdateGlowColor(mesh:TMesh,r1:Int=255,g1:Int=255,b1:Int=255,al1:Float=0.0,r2:Int=0,g2:Int=0,b2:Int=0,al2:Float=0.0)
' CreateFakePlanetShader:TMesh(parent:TEntity=Null,xs:Float=16.0,ys:Float=16.0,r:Int=255,g:Int=255,b:Int=255,a:Float=1.0)



' ------------------------------------------------------------------------------------------------
' Create a Glow Mesh
' ------------------------------------------------------------------------------------------------
Function CreateGlow:TMesh(parent:TEntity = Null, radius1:Float = 1.0, radius2:Float = 2.0, segments:Int = 360, fx:Int = 0, blend:Int = 0, r1:Int = 255, g1:Int = 255, b1:Int = 255, al1:Float = 1.0, r2:Int = 255, g2:Int = 255, b2:Int = 255, al2:Float = 1.0, Inverse:Int = False)
	
	Local a1:Float, a2:Float, a3:Float, a4:Float, angle:Int
	Local v:Int, v0:Int, v1:Int, v2:Int, v3:Int
	Local mesh:TMesh = CreateMesh(parent)
	Local surf:TSurface = CreateSurface(mesh)
	
	If SEGMENTS > 360 Then SEGMENTS = 360
	
	For angle = 1 To SEGMENTS
		
		a1 = angle * 360.0 / SEGMENTS
		a2 = angle * 360.0 / SEGMENTS + 360.0 / SEGMENTS
		a3 = angle * 360.0 / SEGMENTS + 180.0 / SEGMENTS
		a4 = angle * 360.0 / SEGMENTS - 180.0 / SEGMENTS
		
		If Inverse Then

			v0 = AddVertex(surf, radius1 * Cos(a1), radius1 * Sin(a1), 0, 1, 0)
			v1 = AddVertex(surf, radius1 * Cos(a2), radius1 * Sin(a2), 0, 1, 1)
			v2 = AddVertex(surf, radius2 * Cos(a3), radius2 * Sin(a3), 0, 0, 0)
			v3 = AddVertex(surf, radius2 * Cos(a4), radius2 * Sin(a4), 0, 0, 1)

		Else

			v0 = AddVertex(surf, radius1 * Cos(a1), radius1 * Sin(a1), 0, 0, 0)
			v1 = AddVertex(surf, radius1 * Cos(a2), radius1 * Sin(a2), 0, 0, 0)
			v2 = AddVertex(surf, radius2 * Cos(a3), radius2 * Sin(a3), 0, 1, 1)
			v3 = AddVertex(surf, radius2 * Cos(a4), radius2 * Sin(a4), 0, 1, 1)
		
		EndIf

		VertexColor surf, v0, r1, g1, b1, al1
		VertexColor surf, v1, r1, g1, b1, al1
		VertexColor surf, v2, r2, g2, b2, al2
		VertexColor surf, v3, r2, g2, b2, al2
		
		AddTriangle surf, v2, v1, v0
		AddTriangle surf, v0, v3, v2
		
	Next
	
	For v = 0 To CountVertices(surf) - 1
		
		VertexTexCoords surf, v, -VertexX(surf, v), -VertexY(surf, v), 0, 1
		
	Next
	
	If fx > 0 Then EntityFX mesh, fx
	If blend > 0 Then EntityBlend mesh, blend
	
	Return mesh
	
End Function



' ------------------------------------------------------------------------------------------------
' Update a Glow Mesh
' ------------------------------------------------------------------------------------------------
Function UpdateGlow(mesh:TMesh, radius1:Float = 1.0, radius2:Float = 2.0, segments:Int = 360)
	
	Local an1:Float, an2:Float, an3:Float, an4:Float, angle:Int
	
	Local surf:TSurface = GetSurface(mesh, 1)
	Local v:Int = 0
	
	For angle = 1 To SEGMENTS
		
		an1 = angle * 360.0 / SEGMENTS
		an2 = angle * 360.0 / SEGMENTS + 360.0 / SEGMENTS
		an3 = angle * 360.0 / SEGMENTS + 180.0 / SEGMENTS
		an4 = angle * 360.0 / SEGMENTS - 180.0 / SEGMENTS

		VertexCoords surf, v + 0, radius1 * Cos(an1), radius1 * Sin(an1), 0
		VertexCoords surf, v + 1, radius1 * Cos(an2), radius1 * Sin(an2), 0
		VertexCoords surf, v + 2, radius2 * Cos(an3), radius2 * Sin(an3), 0
		VertexCoords surf, v + 3, radius2 * Cos(an4), radius2 * Sin(an4), 0
		
		v = v + 4
			
	Next

End Function



' ------------------------------------------------------------------------------------------------
' Update only the inner vertices
' ------------------------------------------------------------------------------------------------
Function UpdateInnerGlow(mesh:TMesh, Alpha:Float = 0.0)

	Local v:Int
	Local segments:Int = 360
	Local surf:TSurface = GetSurface(mesh, 1)

	For v = 1 To segments * 4 Step 4
		
		VertexColor surf, v - 1, VertexRed(surf, v), VertexGreen(surf, v), VertexBlue(surf, v), Alpha
		VertexColor surf, v + 0, VertexRed(surf, v), VertexGreen(surf, v), VertexBlue(surf, v), Alpha

	Next

End Function



' ------------------------------------------------------------------------------------------------
' Update only the outer vertices
' ------------------------------------------------------------------------------------------------
Function UpdateOuterGlow(mesh:TMesh, Alpha:Float = 0.0)

	Local v:Int
	Local segments:Int = 360
	Local surf:TSurface = GetSurface(mesh, 1)

	For v = 1 To SEGMENTS * 4 Step 4
		
		VertexColor surf, v + 1, VertexRed(surf, v), VertexGreen(surf, v), VertexBlue(surf, v), Alpha
		VertexColor surf, v + 2, VertexRed(surf, v), VertexGreen(surf, v), VertexBlue(surf, v), Alpha
		
		'v=v+4		
	Next

End Function



' ------------------------------------------------------------------------------------------------
' Update Glow Color
' ------------------------------------------------------------------------------------------------
Function UpdateGlowColor(mesh:TMesh, r1:Int = 255, g1:Int = 255, b1:Int = 255, al1:Float = 0.0, r2:Int = 0, g2:Int = 0, b2:Int = 0, al2:Float = 0.0)
	
	Local v:Int
	Local surf:TSurface = GetSurface(mesh, 1)
	
	For v = 1 To CountVertices(surf) / 4
		
		VertexColor surf, ((v - 1) * 4) + 0, r1, g1, b1, al1
		VertexColor surf, ((v - 1) * 4) + 1, r1, g1, b1, al1
		VertexColor surf, ((v - 1) * 4) + 2, r2, g2, b2, al2
		VertexColor surf, ((v - 1) * 4) + 3, r2, g2, b2, al2
		
	Next
	
End Function



' ------------------------------------------------------------------------------------------------
' Update Glow Color
' ------------------------------------------------------------------------------------------------
Function UpdateGlowAlpha(mesh:TMesh, al1:Float = 0.0, al2:Float = 0.0)
	
	Local v:Int
	Local surf:TSurface = GetSurface(mesh, 1)
	
	Local V0:Int, V1:Int, V2:Int, V3:Int
	Local R:Int, G:Int, B:Int
	
	For v = 1 To CountVertices(surf) / 4
	
		V0 = ((v - 1) * 4) + 0
		V1 = ((v - 1) * 4) + 1
		V2 = ((v - 1) * 4) + 2
		V3 = ((v - 1) * 4) + 3
		
		VertexColor surf, V0, VertexRed(surf, V0), VertexGreen(surf, V0), VertexBlue(surf, V0), al1
		VertexColor surf, V1, VertexRed(surf, V1), VertexGreen(surf, V1), VertexBlue(surf, V1), al1
		VertexColor surf, V2, VertexRed(surf, V2), VertexGreen(surf, V2), VertexBlue(surf, V2), al2
		VertexColor surf, V3, VertexRed(surf, V3), VertexGreen(surf, V3), VertexBlue(surf, V3), al2
		
	Next
	
End Function

' ------------------------------------------------------------------------------------------------
' Creates a fake Planet Shader Mesh
' ------------------------------------------------------------------------------------------------
Function CreateFakePlanetShader:TMesh(parent:TEntity = Null, xs:Float = 16.0, ys:Float = 16.0, r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
	
	Local mesh:TMesh = CreateMesh(parent)
	Local surf:TSurface = CreateSurface(mesh)
	Local v:Int[4]
	
	Local x:Int, y:Int
	
	For x = 0 To xs - 1
		
		For y = 0 To ys - 1
						
			v[0] = AddVertex(surf, x - xs / 2.0, -y + ys / 2.0, 0, x * 1.0 / xs, y * 1.0 / ys)
			v[1] = AddVertex(surf, x - xs / 2.0, -y + ys / 2.0 - 1, 0, x * 1.0 / xs, (y + 1) * 1.0 / ys)
			v[2] = AddVertex(surf, x - xs / 2.0 + 1, -y + ys / 2.0 - 1, 0, (x + 1) * 1.0 / xs, (y + 1) * 1.0 / ys)
			v[3] = AddVertex(surf, x - xs / 2.0 + 1, -y + ys / 2.0, 0, (x + 1) * 1.0 / xs, y * 1.0 / ys)
			
			AddTriangle(surf, v[3], v[0], v[1])
			AddTriangle(surf, v[2], v[3], v[1])
			
			VertexColor surf, v[0], r, g, b, a
			VertexColor surf, v[1], r, g, b, a
			VertexColor surf, v[2], r, g, b, a
			VertexColor surf, v[3], r, g, b, a
			
			VertexNormal surf, v[0], (x - xs / 2) / xs * 2, (-y + ys / 2.0) / ys * 2, 1
			VertexNormal surf, v[1], (x - xs / 2) / xs * 2, (-y + ys / 2.0 - 1) / ys * 2, 1
			VertexNormal surf, v[2], (x - xs / 2 + 1) / xs * 2, (-y + ys / 2.0 - 1) / ys * 2, 1
			VertexNormal surf, v[3], (x - xs / 2 + 1) / xs * 2, (-y + ys / 2.0) / ys * 2, 1
			
		Next
		
	Next
	
	Return mesh
	
End Function