' CreateDotLight:TMesh(mesh:TMesh,vischeck:Int=True,x:Float=0.0,y:Float=0.0,z:Float=0.0,range:Float=128.0,minlight:Int=128,r:Int=255,g:Int=255,b:Int=255,dummysize:Int=8,dummyshow:Int=True)
' DotLight(mesh:TMesh,light:TEntity,range:Float=128.0,minlight:Int=128,vischeck:Int=True)



' ----------------------------------------------------------------------
' Add a new Dot3 Light to a mesh
' ----------------------------------------------------------------------
Function CreateDotLight:TMesh(mesh:TMesh, vischeck:Int = True, x:Float = 0.0, y:Float = 0.0, z:Float = 0.0, Range:Float = 128.0, minlight:Int = 128, r:Int = 255, g:Int = 255, b:Int = 255, dummysize:Int = 8, dummyshow:Int = True)

	Local Light:TMesh = CreateSphere(2)
	ScaleEntity light, dummysize, dummysize, dummysize
	EntityFX light, 1
	EntityColor light, r, g, b
	PositionEntity light, x, y, z
	DotLight(mesh, light, Range, minlight, vischeck)

	If dummyshow = False Then FreeEntity light Else Return light

End Function



' ----------------------------------------------------------------------------
' lighten up a level or model with a virtual Dot3 light
' ----------------------------------------------------------------------------
Function DotLight(mesh:TMesh, light:TEntity, Range:Float = 128.0, minlight:Int = 128, vischeck:Int = True)

	Local s:Int, v:Int
	Local surf:TSurface

	Local piv:TPivot = CreatePivot()

	Local intensity:Float
	Local d:Float, d1:Float, d2:Float

	Local x:Float, y:Float, z:Float
	Local dx:Float, dy:Float, dz:Float
	Local r:Float, g:Float, b:Float
	Local r1:Float, g1:Float, b1:Float
	Local r2:Float, g2:Float, b2:Float

	Local lx:Float = EntityX(light, 1)
	Local ly:Float = EntityY(light, 1)
	Local lz:Float = EntityZ(light, 1)

	Local vis:Int = False

	' cycle all surfaces
	For s = 1 To CountSurfaces(mesh)

		' get current surface
		surf = GetSurface(mesh, s)

		' cycle all vertices
		For v = 0 To CountVertices(surf) - 1

			' transform vertex coordinates to local coordinates
			TFormPoint VertexX(surf, v), VertexY(surf, v), VertexZ(surf, v), mesh, Null
			x = TFormedX()
			y = TFormedY()
			z = TFormedZ()

			' unflag vertex
			vis = False

			' position helper pivot to vertex position
			' and move it a little bit towards the light source
			PositionEntity piv, x, y, z
			PointEntity piv, light
			MoveEntity piv, 0, 0, 0.1

			' get distance from light to vertex
			d1 = EntityDistance(light, piv)

			' vertex within light range?
			If d1 <= Range And vischeck = True Then

				' do a linepick between light and vertex
				If LinePick(lx, ly, lz, x - lx, y - ly, z - lz) Then

					' flag vertex
					vis = True

					' position helper pivot to picked position
					PositionEntity piv, PickedX(), PickedY(), PickedZ()

					' check distance to picked position from light
					d2 = EntityDistance(light, piv)

					' distance too short? unflag vertex = hit something
					If d2 < d1 Then vis = False

				EndIf

			EndIf

			' only if vertex is flagged
			If (vis = True Or vischeck = False) And d1 < Range Then

				' calculate delta vector
				dx = x - lx
				dy = y - ly
				dz = z - lz

				' calculate distance to delta vector
				d = Sqr(dx * dx + dy * dy + dz * dz)

				' calculate light intensity
				intensity = 1.0 - (d / (Range * 2))
				If intensity < 0.0 Then intensity = 0.0
				If intensity > 1 Then intensity = 1

				' transform vertex normal to local coordinates
				TFormNormal VertexNX(surf, v), VertexNY(surf, v), VertexNZ(surf, v), mesh, Null

				' position helper pivot to new coordinates
				PositionEntity piv, TFormedX(), TFormedY(), TFormedZ(), 1

				' align helper pivot to vector
				AlignToVector(piv, TFormedX(), TFormedY(), TFormedZ())

				' rotate helper pivot
				RotateEntity piv, EntityPitch(piv, 1), EntityYaw(piv, 1), 0, 1

				' transform delta vector to local coordinates			
				TFormNormal dx, dy, dz, light, piv
				x = TFormedX()
				y = TFormedY()
				z = TFormedZ()
				
				' calculate new dot3 colors
				r1 = 255 - ((1.0 - x) * 127.5 * intensity)
				g1 = 255 - ((1.0 - y) * 127.5 * intensity)
				b1 = ((1.0 - z) * 127.5 * intensity)

				' lighten dark areas if set
				If b1 < minlight Then b1 = minlight

				r2 = VertexRed(surf, v)
				g2 = VertexGreen(surf, v)
				b2 = VertexBlue(surf, v)

				r = Filter(r1, r2, "Overlay")
				g = Filter(g1, g2, "Overlay")
				b = Filter(b1, b2, "Overlay")
				
				' assign new color to vertex
				VertexColor surf, v, r, g, b

			EndIf

		Next

	Next

End Function