Type TSceneGraph
	
	'create scenegraph
	Field cluster:TList[,,]
	Field Scale:Int
	Field clustermax:Int

	Method Create:TSceneGraph(size:Int, clustersize:Int)
		
		clustermax:Int = (size / clustersize) + 1
		cluster = New TList[clustermax, clustermax, clustermax]
		
		For Local i:Int = 0 To clustermax - 1
		
			For Local j:Int = 0 To clustermax - 1
			
				For Local k:Int = 0 To clustermax - 1
				
					cluster[i, j, k] = CreateList()
		
				Next
		
			Next
			
		Next
		
		Scale = clustersize
		
		Return Self
		
	End Method
	
	Method AddToSceneGraph:Int(e:TEntity)
	
		Local x:Float = EntityX(e, True)
		Local y:Float = EntityY(e, True)
		Local z:Float = EntityZ(e, True)
		
		Local cx:Int = x / Scale
		Local cy:Int = y / Scale
		Local cz:Int = z / Scale
		
		If cx < 0 Then Return False
		If cy < 0 Then Return False
		If cz < 0 Then Return False
		
		If cx >= clustermax Then Return False
		If cy >= clustermax Then Return False
		If cz >= clustermax Then Return False
		
		ListRemove TEntity.entity_list, e
		ListAddLast cluster[cx, cy, cz], e
		
		Return True
		
	End Method
	
	Method IsVisible:Int(cam:TCamera, size:Int)
	
		'show scenegraph	
		Local bx:Int = EntityX(cam) / Scale
		Local by:Int = EntityY(cam) / Scale
		Local bz:Int = EntityZ(cam) / Scale
	
		For Local j:Int = -size To size
		
			For Local i:Int = -size To size
			
				For Local k:Int = -size To size
				
					Local x:Int = i + bx
					Local y:Int = j + by
					Local z:Int = k + bz
				
					If (x >= 0) And (y >= 0) And (z >= 0) And (x < clustermax) And (y < clustermax) And (z < clustermax) Then
					
						For Local e:TEntity = EachIn cluster[x, y, z]
						
							If SphereInFrustum(cam, e.px, e.py, e.pz, 1) Then Return True
							
						Next
							
					End If
				
				Next
			
			Next
		
		Next
		
		Return False
		
	End Method
	
End Type

Function SphereInFrustum:Float(cam:TCamera, x:Float, y:Float, z:Float, radius:Float)
	
	Local d:Float
		
	For Local p:Int = 0 To 5
	
		d:Float = cam.frustum[p, 0] * x + cam.frustum[p, 1] * y + cam.frustum[p, 2] * - z + cam.frustum[p, 3]
		If d <= - radius Then Return 0
	
	Next
	
	Return d + radius
	
End Function