' ------------------------------------------------------------------------------------------------
' Quad Type
' ------------------------------------------------------------------------------------------------
Type TQuad

	Field x:Float = 0.0										' position x
	Field y:Float = 0.0										' position y
	Field z:Float = 0.0										' position z
	
	Field id:Int
	
	Field xx1:Float
	Field yy1:Float
	Field zz1:Float
	
	Field xx2:Float
	Field yy2:Float
	Field zz2:Float
	
	Field pitch:Float = 0.0
	Field yaw:Float = 0.0
	Field roll:Float = 0.0
	
	Field row:Int = 0										' texture row
	Field col:Int = 0										' texture column
	Field cat:String = ""
	
	Field size:Float = 1.0									' base size
	Field scale:Float = 1.0									' base scale
	Field scalex:Float = 1.0								' current size X
	Field scaley:Float = 1.0								' current size Y
	Field distance:Float = 0.0								' distance to cam
	
	Field d1:Float
	Field d2:Float
	
	Field Hidden:Int = 0									' hidden flag
	Field vanish:Float = 1.0								' vanish rate
	Field expanding:Float = 1.0								' expand rate
	
	Field RGB:Int[] = [255, 255, 255, 255]					' star vertex color

	Field RGB1:Int[] = [255, 255, 255, 255]					' nebula vertex color
	Field RGB2:Int[] = [255, 255, 255, 255]					' nebula vertex color
	Field RGB3:Int[] = [255, 255, 255, 255]					' nebula vertex color
	Field RGB4:Int[] = [255, 255, 255, 255]					' nebula vertex color

	Field Alpha:Float = 1.0									' vertex alpha
	Field Alpha1:Float = 1.0								' vertex alpha #1
	Field Alpha2:Float = 1.0								' vertex alpha #2
	Field Alpha3:Float = 1.0								' vertex alpha #3
	Field Alpha4:Float = 1.0								' vertex alpha #4

	Field v:Int = 0											' vertex counter
	Field mesh:TMesh = Null									' mesh pointer
	Field surf:TSurface = Null								' surface pointer

	Field rotation:Float
	Field updatetime:Int
				
	Global temp:TPivot = CreatePivot()


	' --------------------------------------------------------------------------------------------
	' METHOD: Add new Quad
	' --------------------------------------------------------------------------------------------
	Method Add(col:Int = 0, row:Int = 0, modus:Int = 0, newsurf:Int = False)

		' surface setup
		If surf = Null Then surf = surf
		
		If CountVertices(surf) + 4 > 70000 And newsurf Then
		
		'If v + 4 > 32768 Then
			v = 0
			surf = CreateSurface(mesh)
			
			'Print"NEW SURFAC"
		EndIf

		' add Vertices
		Local V0:Int = AddVertex(surf, 0, 0, 0, 1, 0)
		Local V1:Int = AddVertex(surf, 0, 0, 0, 1, 1)
		Local V2:Int = AddVertex(surf, 0, 0, 0, 0, 1)
		Local V3:Int = AddVertex(surf, 0, 0, 0, 0, 0)

		If modus = 0 Then
		
			' color vertices
			VertexColor surf, V0, RGB[0], RGB[1], RGB[2], Alpha
			VertexColor surf, V1, RGB[0], RGB[1], RGB[2], Alpha
			VertexColor surf, V2, RGB[0], RGB[1], RGB[2], Alpha
			VertexColor surf, V3, RGB[0], RGB[1], RGB[2], Alpha
			
		Else
		
			' color vertices
			VertexColor surf, V0, RGB1[0], RGB1[1], RGB1[2], Alpha1
			VertexColor surf, V1, RGB2[0], RGB2[1], RGB2[2], Alpha2
			VertexColor surf, V2, RGB3[0], RGB3[1], RGB3[2], Alpha3
			VertexColor surf, V3, RGB4[0], RGB4[1], RGB4[2], Alpha4

		EndIf

		' connect triangles
		AddTriangle surf, V0, V1, V2
		AddTriangle surf, V0, V2, V3
		
		VertexTexCoords surf, V0, col + 1, row
		VertexTexCoords surf, V1, col + 1, row + 1
		VertexTexCoords surf, V2, col, row + 1
		VertexTexCoords surf, V3, col, row

		' increase vertex counter
		If v >= 4 Then v = V0 + 4 Else v = V0
		
	End Method



	' --------------------------------------------------------------------------------------------
	' METHOD: Hide a Quad
	' --------------------------------------------------------------------------------------------
	Method Hide()

		distance = 2 ^ 32

		' set vertices
		VertexCoords surf, v + 0, distance, distance, distance
		VertexCoords surf, v + 1, distance, distance, distance
		VertexCoords surf, v + 2, distance, distance, distance
		VertexCoords surf, v + 3, distance, distance, distance

		hidden = 1

	End Method

	
	Method UpdateVertex(vx:Int, x:Float, y:Float, z:Float)
	
		VertexCoords surf, v + vx, x, y, z
	
	End Method


	' --------------------------------------------------------------------------------------------
	' METHOD: Update a Quad
	' --------------------------------------------------------------------------------------------
	Method Update(target:TEntity)
	
		If Alpha <= 0 Then
		
			Hide
			hidden = 1
						
		Else

			TFormVector scalex, 0, 0, target, Null
			Local X1:Float = TFormedX()
			Local Y1:Float = TFormedY()
			Local Z1:Float = TFormedZ()
	    
			TFormVector 0, scaley, 0, target, Null
			Local X2:Float = TFormedX()
			Local Y2:Float = TFormedY()
			Local Z2:Float = TFormedZ()
			
			' set vertices
			VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
			VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
			VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
			VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
		
			' set colors
			'VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], Alpha
			'VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], Alpha
			'VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], Alpha
			'VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], Alpha
			
			hidden = 0

		EndIf
			
	End Method

		' --------------------------------------------------------------------------------------------
	' METHOD: Update a Quad
	' --------------------------------------------------------------------------------------------
	Method UpdateLine(target:TEntity)
	
		TFormVector scalex, 0, 0, target, Null
		Local X1:Float = TFormedX()
		Local Y1:Float = TFormedY()
		Local Z1:Float = TFormedZ()
	    
		TFormVector 0, scaley, 0, target, Null
		Local X2:Float = TFormedX()
		Local Y2:Float = TFormedY()
		Local Z2:Float = TFormedZ()
			
		' set vertices
		VertexCoords surf, v + 0, x - X1 - X2, y - Y1 - Y2, z - Z1 - Z2
		VertexCoords surf, v + 1, x - X1 + X2, y - Y1 + Y2, z - Z1 + Z2
		VertexCoords surf, v + 2, x + X1 + X2, y + Y1 + Y2, z + Z1 + Z2
		VertexCoords surf, v + 3, x + X1 - X2, y + Y1 - Y2, z + Z1 - Z2
				
	End Method
	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateAlpha(a:Float = 1.0)
	
		' set colors
		VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], Alpha1 * a
		VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], Alpha2 * a
		VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], Alpha3 * a
		VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], Alpha4 * a
			
	End Method

	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateAllAlpha(a:Float = 1.0)
	
		' set colors
		VertexColor surf, v + 0, RGB[0], RGB[1], RGB[2], a
		VertexColor surf, v + 1, RGB[0], RGB[1], RGB[2], a
		VertexColor surf, v + 2, RGB[0], RGB[1], RGB[2], a
		VertexColor surf, v + 3, RGB[0], RGB[1], RGB[2], a
			
	End Method
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateVertexColors(r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0)
	
		' set colors
		VertexColor surf, v + 0, r, g, b, a * Alpha
		VertexColor surf, v + 1, r, g, b, a * Alpha
		VertexColor surf, v + 2, r, g, b, a * Alpha
		VertexColor surf, v + 3, r, g, b, a * Alpha
			
	End Method
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update Alpha
	' --------------------------------------------------------------------------------------------
	Method UpdateScale()
	
		PositionEntity temp, x, y, z
		RotateEntity temp, pitch, yaw, roll
	
		TFormVector scalex, 0, 0, temp, Null
		Local X1:Float = TFormedX()
		Local Y1:Float = TFormedY()
		Local Z1:Float = TFormedZ()
    
		TFormVector 0, scaley, 0, temp, Null
		Local X2:Float = TFormedX()
		Local Y2:Float = TFormedY()
		Local Z2:Float = TFormedZ()
		
		' set vertices
		VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
		VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
		VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
		VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
			
	End Method
		
	
	
	' --------------------------------------------------------------------------------------------
	' METHOD: Update a Quad
	' --------------------------------------------------------------------------------------------
	Method UpdateRotation(target:TEntity)
	
		Local PIVOT:TPivot = CreatePivot()
	
		If (Alpha1 + Alpha2 + Alpha3 + Alpha4) <= 0 Then
			
			Hide
			
		Else
					
			PositionEntity PIVOT, x, y, z
	
			PointEntity PIVOT, target
			RotateEntity PIVOT, EntityPitch(target), EntityYaw(target), rotation
			
			TFormVector scalex, 0, 0, PIVOT, Null
			Local X1:Float = TFormedX()
			Local Y1:Float = TFormedY()
			Local Z1:Float = TFormedZ()
	    
			TFormVector 0, scaley, 0, PIVOT, Null
			Local X2:Float = TFormedX()
			Local Y2:Float = TFormedY()
			Local Z2:Float = TFormedZ()
			
			' set vertices
			VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
			VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
			VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
			VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
		
			' set colors
			VertexColor surf, v + 0, RGB1[0], RGB1[1], RGB1[2], Alpha1
			VertexColor surf, v + 1, RGB2[0], RGB2[1], RGB2[2], Alpha2
			VertexColor surf, v + 2, RGB3[0], RGB3[1], RGB3[2], Alpha3
			VertexColor surf, v + 3, RGB4[0], RGB4[1], RGB4[2], Alpha4
			
		End If
		
		FreeEntity PIVOT

	End Method

	Method AlignToTarget(x:Float, y:Float, z:Float, angle:Float = 0.0)
	
		Local PIVOT:TPivot = CreatePivot()
	
		PositionEntity PIVOT, x, y, z
					
		Local yaw:Float,pitch:Float,roll:Float
		Local x1:Float,y1:Float,z1:Float
		Local x2:Float,y2:Float,z2:Float
		
		yaw=-ATan2(x,z)
		
		x1=z*Sin(yaw)+x*Cos(yaw)
		y1=y	
		z1=z*Cos(yaw)-x*Sin(yaw)
		
		pitch=-ATan2(y1,z1)
	
		x2=x1
		y2=y1*Cos(pitch)-z1*Sin(pitch)
		z2=y1*Sin(pitch)+z1*Cos(pitch)
		
		roll= -ATan2(x2, y2)
	
		If y<0 Then roll:+180
		
		RotateEntity PIVOT, pitch, yaw, roll + angle

		TFormVector scalex, 0, 0, PIVOT, Null
		x1 = TFormedX()
		y1 = TFormedY()
		z1 = TFormedZ()
	    
		TFormVector 0, scaley, 0, PIVOT, Null
		x2 = TFormedX()
		y2 = TFormedY()
		z2 = TFormedZ()
			
		' set vertices
		VertexCoords surf, v + 0, x - x1 - x2, y - y1 - y2, z - z1 - z2
		VertexCoords surf, v + 1, x - x1 + x2, y - y1 + y2, z - z1 + z2
		VertexCoords surf, v + 2, x + x1 + x2, y + y1 + y2, z + z1 + z2
		VertexCoords surf, v + 3, x + x1 - x2, y + y1 - y2, z + z1 - z2
		
		' set colors
		VertexColor surf, v + 0, RGB1[0], RGB1[1], RGB1[2], Alpha1
		VertexColor surf, v + 1, RGB2[0], RGB2[1], RGB2[2], Alpha2
		VertexColor surf, v + 2, RGB3[0], RGB3[1], RGB3[2], Alpha3
		VertexColor surf, v + 3, RGB4[0], RGB4[1], RGB4[2], Alpha4
		
		FreeEntity PIVOT
				
	End Method
	
End Type