' LoadBrushPixmap:TBrush(pixmapin:TPixmap, Flags:Int = 1, u_scale:Float = 1.0, v_scale:Float = 1.0)
' LoadTexturePixmap:TTexture(pixmapin:TPixmap, flags:Int = 1)
' SavePixmapTGA(pixmap:TPixmap, filename:String, depth:Int = 32)

Include "FPixmap.Blur.bmx"
Include "FPixmap.TGA.bmx"



' ----------------------------------------------------------------------------
' Fast OpenGL DrawPixmap
' ----------------------------------------------------------------------------
Function FastGLDrawPixmap(p:TPixmap, x:Int, y:Int)

	glDisable(GL_TEXTURE_2D)
	glPixelZoom(1, -1)
	glRasterPos2i(0, 0)
	glBitmap(0, 0, 0, 0, x, -y, Null)
	glPixelStorei(GL_UNPACK_ROW_LENGTH, p.pitch Shr 2)
	glDrawPixels(p.width, p.Height, GL_RGBA, GL_UNSIGNED_BYTE, p.Pixels)

End Function



' ----------------------------------------------------------------------------
' Load a Pixmap as a Brush
' ----------------------------------------------------------------------------
Function LoadBrushPixmap:TBrush(pixmapin:TPixmap, Flags:Int = 1, u_scale:Float = 1.0, v_scale:Float = 1.0)

	Return PixTBrush.LoadBrushPixmap(pixmapin, flags, u_scale, v_scale)
	
End Function



' ----------------------------------------------------------------------------
' Load a Pixmap as a Texture
' ----------------------------------------------------------------------------
Function LoadTexturePixmap:TTexture(pixmapin:TPixmap, flags:Int = 1)

	Return PixTTexture.LoadTexturePixmap(pixmapin, flags)
	
End Function



' ----------------------------------------------------------------------------
' Type extension for TBrush
' ----------------------------------------------------------------------------
Type PixTBrush Extends TBrush

	Function LoadBrushPixmap:TBrush(pixmapin:TPixmap, flags:Int = 1, u_scale:Float = 1.0, v_scale:Float = 1.0)
	
		Local brush:TBrush = New TBrush
		
		brush.tex[0] = PixTTexture.LoadTexturePixmap:TTexture(pixmapin, flags)
		brush.no_texs = 1
		
		'brush.tex[0].u_scale#=u_scale#
		'brush.tex[0].v_scale#=v_scale#
				
		Return brush
		
	End Function
	
End Type



' ----------------------------------------------------------------------------
' Type extension for TTexture
' ----------------------------------------------------------------------------
Type PixTTexture Extends TTexture

	Function LoadTexturePixMap:TTexture(pixmapin:TPixmap, flags:Int = 1, tex:TTexture = Null)
	
		Return LoadAnimTexturePixMap:TTexture(pixmapin, flags, 0, 0, 0, 1, tex)
		
	End Function

	Function LoadAnimTexturePixMap:TTexture(pixmapin:TPixmap, flags:Int, frame_width:Int, frame_height:Int, first_frame:Int, frame_count:Int, tex:TTexture = Null)
	
		Local pixmapFileName:String = "pixmap" + MilliSecs() + Rnd()
		
		If flags & 128 Then Return LoadCubeMapTexture(pixmapFileName:String, flags, tex)
	
		If tex = Null Then tex:TTexture = New TTexture
		
		tex.file:String = pixmapFileName
		tex.file_abs:String = pixmapFileName
		
		' set tex.flags before TexInList
		tex.flags = flags
		tex.FilterFlags()
		
		' check to see if texture with same properties exists already, if so return existing texture
		Local old_tex:TTexture
		old_tex = tex.TexInList()
		If old_tex <> Null And old_tex <> tex
			Return old_tex
		Else
			If old_tex <> tex
				ListAddLast(tex_list, tex)
			EndIf
		EndIf
	
		' load pixmap
		tex.pixmap = CopyPixmap(pixmapin)
		
		' check to see if pixmap contain alpha layer, set alpha_present to true if so (do this before converting)
		Local alpha_present:Int = False
		If tex.pixmap.format = PF_RGBA8888 Or tex.pixmap.format = PF_BGRA8888 Or tex.pixmap.format = PF_A8 Then alpha_present = True
	
		' convert pixmap to appropriate format
		If tex.pixmap.format <> PF_RGBA8888
			tex.pixmap = tex.pixmap.Convert(PF_RGBA8888)
		EndIf
		
		' if alpha flag is true and pixmap doesn't contain alpha info, apply alpha based on color values
		If tex.flags & 2 And alpha_present = False
			tex.pixmap = ApplyAlpha(tex.pixmap)
		EndIf
	
		' if mask flag is true, mask pixmap
		If tex.flags & 4
			tex.pixmap = MaskPixmap(tex.pixmap, 0, 0, 0)
		EndIf
		
		' ---
		
		' if tex not anim tex, get frame width and height
		If frame_width = 0 And frame_height = 0
			frame_width = tex.pixmap.width
			frame_height = tex.pixmap.Height
		EndIf
	
		' ---
		
		tex.no_frames = frame_count
		tex.gltex = tex.gltex[..tex.no_frames]
	
		' ---
		
		' pixmap -> tex
	
		Local xframes:Int = tex.pixmap.width / frame_width
		Local yframes:Int = tex.pixmap.Height / frame_height
			
		Local startx:Int = first_frame Mod xframes
		Local starty:Int = (first_frame / yframes) Mod yframes
			
		Local x:Int = startx
		Local y:Int = starty
	
		Local pixmap:TPixmap
	
		For Local i:Int = 0 To tex.no_frames - 1
	
			' get static pixmap window. when resize pixmap is called new pixmap will be returned.
			pixmap = tex.pixmap.Window(x * frame_width, y * frame_height, frame_width, frame_height)
			x = x + 1
			If x >= xframes
				x = 0
				y = y + 1
			EndIf
		
			' ---
		
			pixmap = AdjustPixmap(pixmap)
			tex.width = pixmap.width
			tex.Height = pixmap.Height
			Local width:Int = pixmap.width
			Local Height:Int = pixmap.Height
	
			Local Name:Int
			glGenTextures 1, VarPtr Name
			glBindTexture GL_TEXTURE_2D, Name
	
			Local mipmap:Int
			If tex.flags & 8 Then mipmap = True
			Local mip_level:Int = 0
			Repeat
			glPixelStorei GL_UNPACK_ROW_LENGTH, pixmap.pitch / BytesPerPixel[pixmap.format]
			glTexImage2D GL_TEXTURE_2D, mip_level, GL_RGBA8, width, Height, 0, GL_RGBA, GL_UNSIGNED_BYTE, pixmap.Pixels
			If Not mipmap Then Exit
			If width = 1 And Height = 1 Exit
			If width > 1 width:/2
			If Height > 1 Height:/2
	
			pixmap = ResizePixmap(pixmap, width, Height)
			mip_level:+1
			Forever
			tex.no_mipmaps = mip_level
	
			tex.gltex[i] = Name
	
		Next
				
		Return tex
		
	End Function
	
End Type