' GetA:Int(RGB:Int)
' GetR:Int(RGB:Int)
' GetG:Int(RGB:Int)
' GetB:Int(RGB:Int)
' CombineRGBA:Int(r:Int, g:Int, b:Int,a:Int)
' CombineRGB:Int(r:Int, g:Int, b:Int)
' Levels:Int(inPixel:Int, inBlack:Int = 0, inGamma:Float = 1.0, inWhite:Int = 255, outBlack:Int = 0, outWhite:Int = 255)
' Desaturate:Int(rgb:Int)



' ----------------------------------------------------------------------------
' Return A value of a given RGB value
' ----------------------------------------------------------------------------
Function GetA:Int(RGB:Int)
	
	Return RGB Shr 24 & %11111111
	
End Function



' ----------------------------------------------------------------------------
' Return R value of a given RGB value
' ----------------------------------------------------------------------------
Function GetR:Int(RGB:Int)
	
	Return RGB Shr 16 & %11111111
	
End Function



' ----------------------------------------------------------------------------
' Return G value of a given RGB value
' ----------------------------------------------------------------------------
Function GetG:Int(RGB:Int)
	
	Return RGB Shr 8 & %11111111
	
End Function



' ----------------------------------------------------------------------------
' Return B value of a given RGB value
' ----------------------------------------------------------------------------
Function GetB:Int(RGB:Int)
	
	Return RGB & %11111111
	
End Function



' ----------------------------------------------------------------------------
' Return ARGB value of given R,G,B,A single values
' ----------------------------------------------------------------------------
Function CombineRGBA:Int(r:Int, g:Int, b:Int, a:Int)

	Return b | (g Shl 8) | (r Shl 16) | (a Shl 24)
	
End Function



' ----------------------------------------------------------------------------
' Return RGB value of given R,G,B single values
' ----------------------------------------------------------------------------
Function CombineRGB:Int(r:Int, g:Int, b:Int)

	Return b | (g Shl 8) | (r Shl 16)
	
End Function



' ----------------------------------------------------------------------------
' Adjust Levels like in Photoshop
' ----------------------------------------------------------------------------
Function Levels:Int(inPixel:Int, inBlack:Int = 0, inGamma:Float = 1.0, inWhite:Int = 255, outBlack:Int = 0, outWhite:Int = 255)

	Return (((inPixel - inBlack) / (inWhite - inBlack) ^ inGamma * (outWhite - outBlack)) + outBlack)

End Function



' ----------------------------------------------------------------------------
' Weighted Desaturation
' ----------------------------------------------------------------------------
Function Desaturate:Int(rgb:Int)

	Local r:Int = GetR(rgb)
	Local g:Int = GetG(rgb)
	Local b:Int = GetB(rgb)

	Local MaxColor:Int
	Local MinColor:Int

	If r > g Then

		MaxColor = r
		MinColor = g

	Else

		MaxColor = g
		MinColor = r

	EndIf

	If b > MaxColor Then

		MaxColor = b

	ElseIf b < MinColor Then

		MinColor = b

	EndIf

	Return 255 - (127.5 * (MaxColor - MinColor) / (255 - MaxColor + MinColor))

End Function



' ----------------------------------------------------------------------------
' Filter functions like in Photoshop
' ----------------------------------------------------------------------------
Function Filter:Int(a:Int, b:Int, F:String = "Average")

	If a > 255 Then a = 255 Else If a < 0 Then a = 0
		If b > 255 Then b = 255 Else If b < 0 Then b = 0

			Local c:Int

			Select f

				Case "Add"
									Return Min(255, (a + b))
				Case "Subtract"
									If (a + b) < 255 Then Return 0 Else Return (a + b) - 255
				Case "Average"
									Return (a + b) Shr 1
				Case "Multiply"
									Return (a * b) Shr 6
				Case "Overlay"
									If a < 128 Then Return (a * b) Shr 7 Else Return 255 - ((255 - a) * (255 - b) Shr 7)
				Case "Exclusion"
									Return a + b - (a * b Shr 7)
				Case "Negation"
									Return 255 - Abs(255 - a - b)
				Case "Difference"
									Return Abs(a - b)
				Case "Darken"
									If a < b Then Return a Else Return b
				Case "Lighten"
									If a > b Then Return a Else Return b
				Case "Screen"
									Return 255 - ((255 - a) * (255 - b) Shr 8)
				Case "Hardlight"
									If b < 128 Then Return (a * b) Shr 7 Else Return 255 - ((255 - b) * (255 - a) Shr 7)
				Case "Lineardodge"
									Return Min(a + b, 255)
				Case "Linearburn"
									Return (a + b) - 192
				Case "Phoenix"
									Return Min(a, b) - Max(a, b) + 255

				Case "Hardmix"
									If Filter(a, b, "VividLight") < 128 Then Return 0 Else Return 255
				Case "Vividlight"
									If a < 128 Then Return Filter(b, (2 * a), "Colorburn") Else Return Filter(b, (2 * (a - 128)), "Colordodge")
				Case "Pinlight"
									If a < 128 Then Return Filter(b, (2 * a), "Darken") Else Return Filter(b, (2 * (a - 128)), "Lighten")
				Case "Linearlight"
									If a < 128 Then Return Filter(b, (2 * a), "Linearburn") Else Return Filter(b, (2 * (a - 128)), "Lineardodge")

				Case "Softlight"
									c = a * b Shr 8
									Return (c + a * (255 - ((255 - a) * (255 - b) Shr 8) - c) Shr 8)

				Case "Colordodge"
									If b = 255 Then
										Return 255
									Else
										c = Floor((a Shl 8) / (255 - b))
										If c > 255 Then Return 255 Else Return c
									EndIf

				Case "Colorburn"
									If b = 0 Then c = 0 Else c = 255 - (((255 - a) Shl 8) / b)
									If c < 0 Then Return 0 Else Return c

				Case "Glow"
									If a = 255 Then
										c = 255
									Else
										c = b * b / (255 - a)
										If c > 255 Then Return 255
									EndIf
									Return c

			End Select

End Function


' ----------------------------------------------------------------------------
' Simple Greyscale: by Average and by Luminosity
' ----------------------------------------------------------------------------
Function Greyscale:Int(r:Int, g:Int, b:Int, f:String = "Average")

	Select f
	
		Case "Average" Return Int((r + g + b) / 3.0)
		
		Case "Luminosity" Return Int(0.21 * r + 0.72 * g + 0.07 * b)
			
	End Select

End Function