' Noise3D:Float(x:Float, y:Float, z:Float)



' --------------------------------------------------------------------------------------------
' Fast Diamondsquare Noise
' --------------------------------------------------------------------------------------------
Global hmap:Float[2048,1024],nmap:Float[2048,1024]
Function FastNoise:TBank(size:Int,scale:Float,multiplier:Float,xoff:Int=0,yoff:Int=0,seed:Int=1,wrapx:Int=True,wrapy:Int=False,bilinear:Int=True)
	
	Local Max_Height:Float,NoiseMapSize:Int,ScaleDifference:Float,StepSize:Float
	Local N1:Float,N2:Float,N3:Float,N4:Float,HX:Float,HY:Float,IX:Float,IY:Float,ICX:Float,ICY:Float,NA:Float,NB:Float,NC:Float,ND:Float
	Local i:Int,x:Int,y:Int,xx:Int,yy:Int
	Local v:Float,maxh:Float=2^16,minh:Float
	
	Local hm:TBank=CreateBank(size*(size/2))
	
	Max_Height=scale*multiplier*16
	
	For y=0 To (size/2)-1 Step 1
		
		For x=0 To size-1 Step 1
			
			hmap[x,y]=Noise((x+xoff),(y+yoff),seed) ' or use Rnd(1)
			
		Next
		
	Next
	
	NoiseMapSize=size/2
	Max_Height=Max_Height*multiplier
	
	Repeat
		
		For y=0 To (NoiseMapSize/2)-1
			
			For x=0 To NoiseMapSize-1
				
				nmap[x,y]=Noise(x,y,seed)*Max_Height
				
			Next
			
		Next
		
		If wrapy=True Then
			
			For i=0 To NoiseMapSize-1
				
				nmap[i,0]=nmap[i,NoiseMapSize/2]
				
			Next
			
		EndIf
		
		If wrapx=True Then
		
			For i=0 To NoiseMapSize-1
			
				nmap[0,i]=nmap[NoiseMapSize,i]
			
			Next
	
		EndIf
		
		ScaleDifference=size*1.0/NoiseMapSize
		StepSize=1.0/Float(ScaleDifference)
		
		For y=0 To (NoiseMapSize/2)-1
			
			For x=0 To NoiseMapSize-1
				
				N1=nmap[x,  y  ]
				N2=nmap[x+1,y  ]
				N3=nmap[x,  y+1]
				N4=nmap[x+1,y+1]
				
				HX=x*ScaleDifference
				HY=y*ScaleDifference
				
				IY=0
				
				For yy=0 To ScaleDifference-1
					
					ICY=1.0-((Cos(IY*180.0)+1.0)/2.0)
					
					IX=0	
					
					For xx=0 To ScaleDifference-1
					
						If bilinear Then
						
							ICX=1.0-((Cos(IX*180.0)+1.0)/2.0)
							NA=N1*(1.0-ICX)
							NB=N2*ICX
							NC=N3*(1.0-ICX)
							ND=N4*ICX
							
						Else
						
							NA = N1*(1.0-Ix)
							NB = N2*Ix
							NC = N3*(1.0-Ix)
							ND = N4*Ix
							
						EndIf
						
						v=hmap[HX+xx,HY+yy]+(NA+NB)*(1.0-ICY)+(NC+ND)*ICY
						
						If v>maxh Then maxh=v
						If v<minh Then minh=v
						
						hmap[HX+xx,HY+yy]=v
						
						IX=IX+StepSize
						
					Next
									
					IY=IY+StepSize	
					
				Next
							
			Next
			
		Next
		
		NoiseMapSize=NoiseMapSize/2
		
		Max_Height=Max_Height*multiplier
		
	Until NoiseMapSize<=2
	
	For x=0 To size-1
		
		For y=0 To (size/2)-1
			
			SetBankPixel(hm,Normalize(hmap[x,y],minh,maxh,0,255),x,y,size)
						
		Next
		
	Next
	
	Return hm
	
End Function