' CreateQuad:TMesh(r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0, fx:Int = 0)
' CreateSegCube:TMesh(segs:Int = 1, parent:TEntity = Null)
' CreateSpherePart:TMesh(segments:Int,parent:TEntity=Null,start_pitch:Float=-90.0,end_pitch:Float=90.0,start_yaw:Float=-180.0,end_yaw:Float=180.0,radius:Float=1.0,multi1:Float=2.0,multi2:Float=0.5)

' ----------------------------------------------------------------------------
' Creates a Quad
' ----------------------------------------------------------------------------
Function CreateQuad:TMesh(r:Int = 255, g:Int = 255, b:Int = 255, a:Float = 1.0, fx:Int = 0)

	Local v1:Int, v2:Int, v3:Int, v4:Int
		
	Local mesh:TMesh = CreateMesh()
	Local surf:TSurface = CreateSurface(mesh)
		
	v1 = AddVertex(surf, -0.5, 0.5, 0.0, 1.0, 0.0)
	v2 = AddVertex(surf, 0.5, 0.5, 0.0, 0.0, 0.0)
	v3 = AddVertex(surf, -0.5, -0.5, 0.0, 1.0, 1.0)
	v4 = AddVertex(surf, 0.5, -0.5, 0.0, 0.0, 1.0)
	
	VertexColor surf, v1, r, g, b, a
	VertexColor surf, v3, r, g, b, a
	VertexColor surf, v2, r, g, b, a
	VertexColor surf, v4, r, g, b, a
	
	AddTriangle(surf, 0, 1, 2)
	AddTriangle(surf, 3, 2, 1)
		
	EntityFX mesh, fx
		
	Return mesh
	
End Function


' ----------------------------------------------------------------------------
' Creates a spherized Cube
' ----------------------------------------------------------------------------
Function CreateCubeSphere:TMesh(segments:Int = 16, mode:Int = 1)
	
	Local s:Int
	Local x:Int, y:Int
	Local vx:Float, vy:Float, vz:Float
	Local magnitude:Float
	Local vertx:Float, verty:Float, vertz:Float
	Local vertex:Int
	
	Local mesh:TMesh = CreateMesh()
	Local surf:TSurface
	
	For s = 1 To 6
		
		surf = CreateSurface(mesh)
		
		For y = 0 To segments
		
			For x = 0 To segments
				
				Select s
				
					Case 1
							vx = x - segments / 2
							vy = segments / 2
							vz = segments / 2 - y

					Case 2
							vx = x - segments / 2
							vy = segments / 2 - y
							vz = -segments / 2
							
					Case 3
							vx = x - segments / 2
							vy = -segments / 2
							vz = y - segments / 2
							
					Case 4
							vx = -segments / 2
							vy = segments / 2 - y
							vz = segments / 2 - x
							
					Case 5
							vx = segments / 2
							vy = segments / 2 - y
							vz = x - segments / 2
							
					Case 6
							vx = segments / 2 - x
							vy = segments / 2 - y
							vz = segments / 2
							
				End Select
				
				If mode = 0 Then
				
					magnitude = Sqr(vx * vx + vy * vy + vz * vz)
					vertx = vx / magnitude
					verty = vy / magnitude
					vertz = vz / magnitude
					
				Else
				
					vx = vx / segments * 2
					vy = vy / segments * 2
					vz = vz / segments * 2
					
					vertx = vx * Sqr(1.0 - (vy * vy) / 2.0 - (vz * vz) / 2.0 + ((vy * vy) * (vz * vz) / 3.0))
					verty = vy * Sqr(1.0 - (vz * vz) / 2.0 - (vx * vx) / 2.0 + ((vz * vz) * (vx * vx) / 3.0))
					vertz = vz * Sqr(1.0 - (vx * vx) / 2.0 - (vy * vy) / 2.0 + ((vx * vx) * (vy * vy) / 3.0))
					
				EndIf
				
				vertex = AddVertex(surf, vertx, verty, vertz, x * 1.0 / segments, y * 1.0 / segments)
				VertexNormal(surf,vertex,vertX,vertY,vertZ)
				
			Next
			
		Next
		
		For y = 0 To segments - 1
		
			For x = 0 To segments - 1
			
				AddTriangle(surf, y * (segments + 1) + x, y * (segments + 1) + x + 1, y * (segments + 1) + x + segments + 2)
				
				AddTriangle(surf, y * (segments + 1) + x, y * (segments + 1) + x + segments + 2, y * (segments + 1) + x + segments + 1)
				
			Next
			
		Next
		
	Next
	
	Return mesh
	
End Function



' ----------------------------------------------------------------------------
' Create a segmented cube
' ----------------------------------------------------------------------------
Function CreateSegCube:TMesh(segs:Int = 1, parent:TEntity = Null)
	
	Local side:Int, surf:TSurface
	Local stx:Float, sty:Float, stp:Float, y:Float
	Local a:Int, x:Float, v:Float, b:Int, u:Float
	Local v0:Int, v1:Int, v2:Int, v3:Int
	Local mesh:TMesh = CreateMesh(parent)
	
	Local surface:TSurface[6]
	
	For Local i:Int = 0 To 5
		
		surface[i] = CreateSurface(mesh)
			
	Next
	
	' sides
	For side = 0 To 3
		
		surf = surface[side]
		stx = -.5
		sty = stx
		stp = Float(1) / Float(segs)
		y = sty
		
		For a = 0 To segs
			
			x = stx
			v = a / Float(segs)
			
			For b = 0 To segs
				
				u = b / Float(segs)
				v0 = AddVertex(surf, x, y, 0.5, u, v)
							
				x = x + stp
				
			Next
			
			y = y + stp
			
		Next
		
		For a = 0 To segs - 1
			
			For b = 0 To segs - 1
				
				v0 = a * (segs + 1) + b
				v1 = v0 + 1
				v2 = (a + 1) * (segs + 1) + b + 1
				v3 = v2 - 1
				
				AddTriangle(surf, v0, v1, v2)
				AddTriangle(surf, v0, v2, v3)
				
			Next
			
		Next
		
		RotateMesh mesh, 0, 90, 0
		
	Next
	
	'top and bottom
	RotateMesh mesh, 0, 90, 90
	
	For side = 0 To 1
		
		surf = surface[4 + side]
		stx:Float = -.5
		sty:Float = stx
		stp:Float = Float(1) / Float(segs)
		y:Float = sty
		
		For a = 0 To segs
			x:Float = stx
			v = a / Float(segs)
			For b = 0 To segs
				u = b / Float(segs)
				v0 = AddVertex(surf, x, y, 0.5, u, v)
				x = x + stp
			Next
			y = y + stp
		Next
		
		For a = 0 To segs - 1
			For b = 0 To segs - 1
				v0 = a * (segs + 1) + b
				v1 = v0 + 1
				v2 = (a + 1) * (segs + 1) + b + 1
				v3 = v2 - 1
				AddTriangle(surf, v0, v1, v2)
				AddTriangle(surf, v0, v2, v3)
			Next
		Next
		
		RotateMesh mesh, 180, 0, 0
		
	Next
	
	' scale uniform to -1 to +1 space in X/Y/Z dimensions
	FitMesh mesh, -1, -1, -1, 2, 2, 2, 1

	RotateMesh mesh, -90, 0, 0
	
	Return mesh
	
End Function


' ----------------------------------------------------------------------------
' Create a segmented Sphere
' ----------------------------------------------------------------------------
Function CreateSpherePart:TMesh(segments:Int, parent:TEntity = Null, start_pitch:Float = -90.0, end_pitch:Float = 90.0, start_yaw:Float = -180.0, end_yaw:Float = 180.0, radius:Float = 1.0, multi1:Float = 2.0, multi2:Float = 0.5)
		
	Local seg_pitch:Int = segments
	Local vert_pitch:Int = seg_pitch + 1
	Local seg_yaw:Int = segments * multi1
	
	Local step_yaw:Float = (end_yaw - start_yaw) / Float(seg_yaw)
	Local step_pitch:Float = (end_pitch - start_pitch) / Float(seg_pitch)
	Local step_u:Float = multi2 / Float(seg_yaw)
	Local step_v:Float = 1.0 / Float(seg_pitch)
	
	Local mesh:TMesh = CreateMesh(parent)
	Local surf:TSurface = CreateSurface(mesh)
	
	Local yaw:Float = start_yaw
	Local pitch:Float = start_pitch

	For Local yaw_i:Int = 0 To seg_yaw
		
		If yaw_i = seg_yaw Then yaw = end_yaw
		
		For Local pitch_i:Int = 0 To seg_pitch
			
			If pitch_i = seg_pitch Then pitch = end_pitch
			
			Local ny:Float = Sin(pitch) / Cos(pitch)
			Local nx:Float = Sin(yaw)
			Local nz:Float = Cos(yaw)
			
			' normalize vector
			Local factor:Float = Sqr(nx * nx + ny * ny + nz * nz)
			nx = nx / Abs(factor)
			ny = ny / Abs(factor)
			nz = nz / Abs(factor)
			
			If Abs(pitch) = 90 Then
				nx = 0
				ny = Sgn(pitch)
				nz = 0
			EndIf
			
			Local v:Int = AddVertex(surf, nx * radius, ny * radius, nz * radius, 1 - step_u * yaw_i, 1 - step_v * pitch_i)
			VertexNormal surf, v, nx, ny, nz

			VertexTexCoords(surf, v, ((yaw + 180.0) / 360.0) + 0.5, (pitch + 90.0) / 180.0, 0, 1)
			
			' connect vertices
			If yaw_i > 0 And pitch_i > 0
				
				AddTriangle surf, yaw_i * vert_pitch + pitch_i, (yaw_i - 1) * vert_pitch + pitch_i - 1, (yaw_i) * vert_pitch + pitch_i - 1
				AddTriangle surf, yaw_i * vert_pitch + pitch_i, (yaw_i - 1) * vert_pitch + pitch_i, (yaw_i - 1) * vert_pitch + pitch_i - 1
				
			EndIf
			
			pitch = pitch + step_pitch

		Next

		pitch = start_pitch
		yaw = yaw + step_yaw

	Next

	Return mesh
	
End Function