' Screenshot()
' PositionSprite(ent:TSprite, x:Int, y:Int, w:Int, h:Int, center:Int = True, Scale:Float = 1.0, rotation:Float = 0.0, offx:Float = 0.0, offy:Float = 0.0, offz:Float = 0.0)
' PositionEntityFrom2D (usecam:TCamera, entity:TMesh, x2d:Float, y2d:Float, positionGlobal:Int = 0, camZoom:Float = 1)



' ----------------------------------------------------------------------------
' Quick Screenshot to current directory
' ----------------------------------------------------------------------------
Function Screenshot()
	
	Local filenum:Int = 0
	Local filename:String
	
    Repeat
	
		filenum:+1
		filename = "Screenshot " + Spaces(filenum, 4, "0") + ".png"
		
		Print filenum
        		
    Until Not(FileType(PATH_Screenshot + filename))
    
    Local img:TPixmap = GrabPixmap(0, 0, GraphicsWidth(), GraphicsHeight())
	SavePixmapPNG(img, PATH_Screenshot + filename, 0)
	
End Function

millisecs



' ----------------------------------------------------------------------------
' Pixel-Perfect Camera Sprites
' ----------------------------------------------------------------------------
Function PositionSprite(ent:TSprite, x:Int, y:Int, w:Int, h:Int, center:Int = True, Scale:Float = 1.0, rotation:Float = 0.0, offx:Float = 0.0, offy:Float = 0.0, offz:Float = 0.0)

	' Calculate Screen scaling
	Local sw:Float = SCREEN_WIDTH
	Local sh:Float = SCREEN_HEIGHT
	Local as:Float = 1.77777777 / SCREEN_ASPECT
	
	Local wf:Float = SCREEN_WIDTH / 2560.0
	Local hf:Float = SCREEN_HEIGHT / 1440.0 / as
			
	x = x * Scaler
	y = y * Scaler
	w = w * Scaler
	h = h * Scaler
	
	If center Then

		' Sprite is centered
		PositionEntity ent, (x - (sw * wf / 2.0)) / wf + offx, -(y - (sh * hf / 2.0)) / hf + 1.0 + offy, (sw / 2.0) + offz
		
	Else
	
		' Sprite is not centered
		PositionEntity ent, (x - (sw * wf / 2.0)) / wf + offx + (w / 2.0), -(y - (sh * hf / 2.0)) / hf + 1.0 + offy + (h / 2.0), (sw / 2.0) + offz
		
	End If

	' Scale Sprite
	ScaleSprite ent, w / 2.0 * Scale, h / 2.0 * Scale
	
	RotateSprite ent, rotation

End Function



' ----------------------------------------------------------------------------
' Position Entity in 3D Space from 2D Screen coordinates
' ----------------------------------------------------------------------------
Function PositionEntityFrom2D (usecam:TCamera, entity:TMesh, x2d:Float, y2d:Float, positionGlobal:Int = 0, camZoom:Float = 1)
	
	Local gw:Int = SCREEN_WIDTH
	Local gh:Int = SCREEN_HEIGHT
	Local x:Float = -((gw / 2) - x2d)
	Local y:Float = (gh / 2) - y2d
	Local parent:TEntity = GetParent (entity)
	EntityParent entity, usecam
	Local z3d:Float = Abs (EntityZ (entity))
	Local div:Float = (gw / (2 / camZoom)) / z3d
	PositionEntity entity, x / div, y / div, z3d, positionGlobal
	EntityParent entity, parent
	
End Function



' ------------------------------------------------------------------------------------------------
' Draw a OpenGL Rectangle
' ------------------------------------------------------------------------------------------------
Function DrawGRect(x:Int, y:Int, w:Int, h:Int)

	DrawGLine(x, y, x + w, y)
	DrawGLine(x + w, y, x + w, y + h)
	DrawGLine(x, y + h, x + w, y + h)
	DrawGLine(x, y, x, y + h)

End Function



' ------------------------------------------------------------------------------------------------
' Draw a OpenGL Line
' ------------------------------------------------------------------------------------------------
Function DrawGLine(x1:Int, y1:Int, x2:Int, y2:Int)

	glVertex2i(x1, y1)
	glVertex2i(x2, y2)
	
End Function



' ------------------------------------------------------------------------------------------------
' Sets a Font (simple)
' ------------------------------------------------------------------------------------------------
Function Font(font:String)
	
	SetBlend ALPHABLEND
	SetImageFont(MEDIA.GetFont(Font))

End Function



' ------------------------------------------------------------------------------------------------
' Draws a text with line breaks using a divider
' ------------------------------------------------------------------------------------------------
Function DrawLines(txt:String, x:Int, y:Int, divider:String = "~n")

  For Local line:String = EachIn txt.split(divider)
  
    DrawText line, x, y
	
    y:+(TextHeight(line)*Scaler)
	
  Next
  
End Function



Function DrawTextRect(x:Int, y:Int, w:Int, h:Int, Text:String)

	' seperate text into words with spaces,tabs & crlf
	Local words:String[], ss:String, idx:Int
	Repeat		
		ss = GetNextEx( text, [" ","~t"])
		idx = ss.Find( "~n")
		If idx <> -1 Then
			Repeat
				Local tmp:String = GetNextEx( ss, ["~r~n","~n"])
				If tmp.Length > 0 Then
					words = words[..words.Length + 2]
					words[words.length - 2] = tmp
				EndIf
			Until ss.Length = 0		
		Else
			words = words[..words.Length + 1]
			words[words.Length - 1] = ss		
		EndIf
	Until text.Length = 0	
	' draw it within the suplied frame
	Local xx:Int,yy:Int, ww:Int,hh:Int
	For Local s:String = EachIn words
		If s.length <= 0 Then
			xx = 0
			yy :+ TextHeight("jX")
		Else
			ww = TextWidth(s)
			hh = TextHeight(s)
			If xx + ww > w Then
				xx = 0
				yy :+ hh
			EndIf
			DrawText s, x+xx,y+yy
			xx :+ ww + TextWidth( " ")
		EndIf
	Next
EndFunction

Function GetNextEx:String(Value:String Var, seps:String[])
	Local index:Int, s:String
	If (value.Length <= 0) Or (seps.Length <= 0) Then Return Null
	For s = EachIn seps
		index = value.Find( s)
		If index = 0 Then
			value = value[s.Length..]
			Return Null
		ElseIf index >= 1 Then			
			Local res:String = value[..index]
			value = value[index + s.Length..]
			Return res
		EndIf
	Next
	If value.Length > 0 Then
		s = value
		value = Null
		Return s
	EndIf
	Return Null
EndFunction



' ------------------------------------------------------------------------------------------------
' Max2D Setcolor Fix for patched BeginMax2D/EndMax2D
' ------------------------------------------------------------------------------------------------
Function SetColor(RED:Int = 255, green:Int = 255, blue:Int = 255, Alpha:Float = 1.0)

	Local col:Float[] = [RED / 255.0, green / 255.0, blue / 255.0, Alpha]

	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_BLEND)
	glTexEnvfv(GL_TEXTURE_ENV, GL_TEXTURE_ENV_COLOR, col)

	_max2dDriver.SetColor RED, green, blue

	
End Function